/*
 * Decompiled with CFR 0.152.
 */
package com.github.nfwork.dbfound.starter.dbprovide;

import com.github.nfwork.dbfound.starter.ModelExecutor;
import com.nfwork.dbfound.core.Context;
import com.nfwork.dbfound.core.Transaction;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class DBFoundTransactionManager
extends AbstractPlatformTransactionManager {
    private final ThreadLocal<TransactionObject> threadLocal = new ThreadLocal();

    public DBFoundTransactionManager(ModelExecutor modelExecutor) {
        modelExecutor.setDbFoundTransactionManager(this);
    }

    protected Object doGetTransaction() throws TransactionException {
        TransactionObject transactionObject = this.threadLocal.get();
        if (transactionObject == null) {
            transactionObject = new TransactionObject();
            this.threadLocal.set(transactionObject);
        }
        return transactionObject;
    }

    protected void doBegin(Object o, TransactionDefinition transactionDefinition) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)o;
        transactionObject.transaction.begin();
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        TransactionObject transactionObject = this.threadLocal.get();
        if (transactionObject != null) {
            transactionObject.transaction.commit();
        }
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        TransactionObject transactionObject = this.threadLocal.get();
        if (transactionObject != null) {
            transactionObject.transaction.rollback();
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionObject transactionObject = this.threadLocal.get();
        if (transactionObject != null) {
            transactionObject.transaction.end();
            this.threadLocal.remove();
        }
        super.doCleanupAfterCompletion(transaction);
    }

    public void registContext(Context context) {
        TransactionObject transactionObject = this.threadLocal.get();
        if (transactionObject != null) {
            context.setTransaction(transactionObject.transaction);
        }
    }

    public static class TransactionObject {
        Transaction transaction = new Transaction();
    }
}

