/*
 * Decompiled with CFR 0.152.
 */
package com.github.nfwork.dbfound.starter.exception;

import com.nfwork.dbfound.dto.ResponseObject;
import com.nfwork.dbfound.exception.CollisionException;
import com.nfwork.dbfound.exception.DBFoundPackageException;
import com.nfwork.dbfound.exception.FileDownLoadInterrupt;
import com.nfwork.dbfound.util.LogUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class DBFoundExceptionHandle {
    public ResponseObject handle(Exception exception, HttpServletRequest request, HttpServletResponse response) {
        ResponseObject ro = new ResponseObject();
        try {
            if (exception instanceof CollisionException) {
                response.setStatus(403);
            } else {
                response.setStatus(500);
            }
            exception = DBFoundExceptionHandle.getException(exception);
            if (exception instanceof FileDownLoadInterrupt) {
                LogUtil.warn((String)exception.getMessage());
                return null;
            }
            String em = exception.getMessage();
            String code = null;
            if (exception instanceof CollisionException) {
                code = ((CollisionException)exception).getCode();
                LogUtil.info((String)(exception.getClass().getName() + ":" + em));
            } else {
                LogUtil.error((String)em, (Throwable)exception);
                em = exception.getClass().getName() + ":" + em;
            }
            ro.setMessage(em);
            ro.setSuccess(false);
            ro.setCode(code);
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return ro;
    }

    private static Exception getException(Exception exception) {
        Throwable throwable;
        if (exception instanceof DBFoundPackageException && (throwable = exception.getCause()) instanceof Exception) {
            return (Exception)throwable;
        }
        return exception;
    }
}

