/*
 * Decompiled with CFR 0.152.
 */
package com.github.nfwork.dbfound.starter.controller;

import com.github.nfwork.dbfound.starter.annotation.ContextAware;
import com.github.nfwork.dbfound.starter.exception.DBFoundExceptionHandle;
import com.github.nfwork.dbfound.starter.service.DBFoundDefaultService;
import com.nfwork.dbfound.core.Context;
import com.nfwork.dbfound.dto.ResponseObject;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DBFoundDefaultController {
    @Autowired
    DBFoundDefaultService service;
    @Autowired
    DBFoundExceptionHandle exceptionHandle;

    @RequestMapping(value={"/**/*.query"})
    public ResponseObject query(@ContextAware Context context) {
        return this.query(context, null);
    }

    @RequestMapping(value={"/**/*.query!{queryName}"})
    public ResponseObject query(@ContextAware Context context, @PathVariable String queryName) {
        try {
            String uri = context.request.getServletPath();
            String modelName = uri.substring(1, uri.indexOf(".query"));
            ResponseObject object = this.service.query(context, modelName, queryName);
            if (context.isOutMessage()) {
                return object;
            }
            return null;
        }
        catch (Exception e) {
            return this.exceptionHandle.handle(e, context.request, context.response);
        }
    }

    @RequestMapping(value={"/**/*.execute"})
    public ResponseObject execute(@ContextAware Context context) {
        return this.execute(context, null);
    }

    @RequestMapping(value={"/**/*.execute!{executeName}"})
    public ResponseObject execute(@ContextAware Context context, @PathVariable String executeName) {
        try {
            String uri = context.request.getServletPath();
            String modelName = uri.substring(1, uri.indexOf(".execute"));
            Object gridData = context.getData("param.GridData");
            ResponseObject object = gridData instanceof List ? this.service.batchExecute(context, modelName, executeName) : this.service.execute(context, modelName, executeName);
            if (context.isOutMessage()) {
                return object;
            }
            return null;
        }
        catch (Exception e) {
            return this.exceptionHandle.handle(e, context.request, context.response);
        }
    }

    @RequestMapping(value={"/**/*.export"})
    public ResponseObject export(@ContextAware Context context) {
        return this.export(context, null);
    }

    @RequestMapping(value={"/**/*.export!{queryName}"})
    public ResponseObject export(@ContextAware Context context, @PathVariable String queryName) {
        try {
            String uri = context.request.getServletPath();
            String modelName = uri.substring(1, uri.indexOf(".export"));
            this.service.export(context, modelName, queryName);
            return null;
        }
        catch (Exception e) {
            return this.exceptionHandle.handle(e, context.request, context.response);
        }
    }
}

