/*
 * Decompiled with CFR 0.152.
 */
package com.github.nfwork.dbfound.starter;

import com.github.nfwork.dbfound.starter.autoconfigure.DBFoundConfigProperties;
import com.github.nfwork.dbfound.starter.dbprovide.SpringDataSourceProvide;
import com.nfwork.dbfound.core.DBFoundConfig;
import com.nfwork.dbfound.db.DataSourceConnectionProvide;
import com.nfwork.dbfound.model.dsql.DSqlConfig;
import com.nfwork.dbfound.util.JsonUtil;
import com.nfwork.dbfound.util.LogUtil;
import com.nfwork.dbfound.web.i18n.MultiLangUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.springframework.util.StringUtils;

public class DBFoundEngine {
    private DBFoundConfigProperties.SystemConfig systemConfig;
    private DBFoundConfigProperties.WebConfig webConfig;

    public void initSystem(DBFoundConfigProperties.SystemConfig config) {
        this.systemConfig = config;
        DBFoundConfig.setOpenLog((boolean)config.isOpenLog());
        DBFoundConfig.setModelLoadRoot((String)config.getModeRootPath());
        DBFoundConfig.setUnderscoreToCamelCase((boolean)config.isUnderscoreToCamelCase());
        DBFoundConfig.setCamelCaseToUnderscore((boolean)config.isCamelCaseToUnderscore());
        DBFoundConfig.setDateFormat((String)config.getDateFormat());
        DBFoundConfig.setDateTimeFormat((String)config.getDateTimeFormat());
        DBFoundConfig.setModelModifyCheck((boolean)config.isModelModifyCheck());
        DSqlConfig.setCompareIgnoreCase((boolean)config.isSqlCompareIgnoreCase());
        DSqlConfig.setOpenDSql((boolean)config.isOpenDSql());
        LogUtil.info((String)("dbfound engine init system success, config:" + JsonUtil.beanToJson((Object)this.systemConfig)));
    }

    public void initWeb(DBFoundConfigProperties.WebConfig config) {
        this.webConfig = config;
        if (config.getI18nProvide() != null) {
            MultiLangUtil.init((String)config.getI18nProvide());
        }
        DBFoundConfig.setEncoding((String)config.getEncoding());
        DBFoundConfig.setBasePath((String)this.webConfig.getBasePath());
        DBFoundConfig.setOpenSession((boolean)this.webConfig.isOpenSession());
        DBFoundConfig.setJsonStringAutoCover((boolean)config.isJsonStringAutoCover());
        LogUtil.info((String)("dbfound engine init web success, config:" + JsonUtil.beanToJson((Object)this.webConfig)));
    }

    public void initDBItem(DBFoundConfigProperties.DBItemConfig dbconfig) throws IllegalAccessException, InvocationTargetException {
        if (!StringUtils.isEmpty((Object)dbconfig.getUrl())) {
            BasicDataSource ds = new BasicDataSource();
            BeanUtils.copyProperties((Object)ds, (Object)dbconfig);
            SpringDataSourceProvide provide = new SpringDataSourceProvide(dbconfig.getProvideName(), ds, dbconfig.getDialect());
            provide.regist();
            LogUtil.info((String)("dbfound engine init datasource success, provideName:" + dbconfig.getProvideName() + ", url:" + dbconfig.getUrl()));
        }
    }

    public List<DataSourceConnectionProvide> getDatasourceProvideList() {
        return DBFoundConfig.getDsp();
    }

    public void destroy() {
        LogUtil.info((String)"NFWork dbfound 3.3.0 engine destroy begin");
        DBFoundConfig.destroy();
        LogUtil.info((String)"NFWork dbfound 3.3.0 engine destroy success");
    }

    public DBFoundConfigProperties.SystemConfig getSystemConfig() {
        return this.systemConfig;
    }

    public DBFoundConfigProperties.WebConfig getWebConfig() {
        return this.webConfig;
    }
}

