/*
 * Decompiled with CFR 0.152.
 */
package com.github.nfwork.dbfound.starter.dbprovide;

import com.github.nfwork.dbfound.starter.ModelExecutor;
import com.github.nfwork.dbfound.starter.dbprovide.Transaction;
import com.github.nfwork.dbfound.starter.dbprovide.TransactionObject;
import com.nfwork.dbfound.core.Context;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DBFoundTransactionManager
extends AbstractPlatformTransactionManager {
    private final Isolation transactionIsolation;

    public DBFoundTransactionManager(ModelExecutor modelExecutor, Isolation transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
        modelExecutor.setDbFoundTransactionManager(this);
    }

    protected Object doGetTransaction() throws TransactionException {
        TransactionObject transactionObject = new TransactionObject();
        Transaction transaction = (Transaction)((Object)TransactionSynchronizationManager.getResource((Object)((Object)this)));
        if (transaction != null) {
            transactionObject.setTransaction(transaction, false);
        }
        return transactionObject;
    }

    protected void doBegin(Object o, TransactionDefinition definition) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)o;
        if (transactionObject.getTransaction() == null) {
            Transaction transaction = new Transaction();
            transactionObject.setTransaction(transaction, true);
        }
        if (definition.getIsolationLevel() != -1) {
            transactionObject.getTransaction().setTransactionIsolation(definition.getIsolationLevel());
        } else if (this.transactionIsolation.value() != -1) {
            transactionObject.getTransaction().setTransactionIsolation(this.transactionIsolation.value());
        }
        transactionObject.getTransaction().setReadOnly(definition.isReadOnly());
        transactionObject.getTransaction().begin();
        if (transactionObject.isNew()) {
            TransactionSynchronizationManager.bindResource((Object)((Object)this), (Object)((Object)transactionObject.getTransaction()));
        }
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)defaultTransactionStatus.getTransaction();
        transactionObject.getTransaction().commit();
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)defaultTransactionStatus.getTransaction();
        transactionObject.getTransaction().rollback();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        TransactionObject transactionObject = (TransactionObject)status.getTransaction();
        transactionObject.getTransaction().setRollbackOnly(true);
    }

    protected boolean isExistingTransaction(Object transaction) {
        TransactionObject transactionObject = (TransactionObject)transaction;
        return !transactionObject.isNew() && transactionObject.getTransaction() != null;
    }

    protected Object doSuspend(Object transaction) {
        TransactionObject transactionObject = (TransactionObject)transaction;
        transactionObject.setTransaction(null);
        return TransactionSynchronizationManager.unbindResource((Object)((Object)this));
    }

    protected void doResume(@Nullable Object obj, Object suspendedResources) {
        TransactionObject transactionObject = (TransactionObject)obj;
        if (transactionObject != null) {
            transactionObject.setTransaction((Transaction)((Object)suspendedResources));
        }
        try {
            TransactionSynchronizationManager.unbindResource((Object)((Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        TransactionSynchronizationManager.bindResource((Object)((Object)this), (Object)suspendedResources);
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        TransactionObject transactionObject = (TransactionObject)transaction;
        transactionObject.getTransaction().end();
        try {
            TransactionSynchronizationManager.unbindResource((Object)((Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registContext(Context context) {
        Transaction transaction = (Transaction)((Object)TransactionSynchronizationManager.getResource((Object)((Object)this)));
        context.setTransaction((com.nfwork.dbfound.core.Transaction)transaction);
    }
}

