/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhenneaux.resilienthttpclient.singlehostclient;

import com.github.nhenneaux.resilienthttpclient.singlehostclient.SingleHostnameX509TrustManager;
import java.net.http.HttpClient;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SingleHostHttpClientProvider {
    private static final String JDK_INTERNAL_HTTPCLIENT_DISABLE_HOSTNAME_VERIFICATION = "jdk.internal.httpclient.disableHostnameVerification";

    public HttpClient buildSingleHostnameHttpClient(String hostname) {
        return this.buildSingleHostnameHttpClient(hostname, null);
    }

    public HttpClient buildSingleHostnameHttpClient(String hostname, KeyStore trustStore) {
        HttpClient.Builder builder = HttpClient.newBuilder();
        return this.buildSingleHostnameHttpClient(hostname, trustStore, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient buildSingleHostnameHttpClient(String hostname, KeyStore trustStore, HttpClient.Builder builder) {
        HttpClient client;
        SSLContext sslContextForSingleHostname = this.buildSslContextForSingleHostname(hostname, trustStore);
        String previousDisable = System.setProperty(JDK_INTERNAL_HTTPCLIENT_DISABLE_HOSTNAME_VERIFICATION, Boolean.TRUE.toString());
        try {
            client = builder.sslContext(sslContextForSingleHostname).build();
        }
        finally {
            if (previousDisable == null) {
                System.clearProperty(JDK_INTERNAL_HTTPCLIENT_DISABLE_HOSTNAME_VERIFICATION);
            } else {
                System.setProperty(JDK_INTERNAL_HTTPCLIENT_DISABLE_HOSTNAME_VERIFICATION, previousDisable);
            }
        }
        return client;
    }

    private SSLContext buildSslContextForSingleHostname(String hostname, KeyStore truststore) {
        TrustManager[] trustOnlyGivenHostname = this.singleHostTrustManager(hostname, truststore);
        SSLContext sslContextForSingleHostname = RethrowGeneralSecurityException.handleGeneralSecurityException(() -> SSLContext.getInstance("TLS"));
        RethrowGeneralSecurityException.handleGeneralSecurityException(() -> sslContextForSingleHostname.init(null, trustOnlyGivenHostname, new SecureRandom()));
        return sslContextForSingleHostname;
    }

    private TrustManager[] singleHostTrustManager(String hostname, KeyStore truststore) {
        TrustManagerFactory instance = RethrowGeneralSecurityException.handleGeneralSecurityException(() -> TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()));
        RethrowGeneralSecurityException.handleGeneralSecurityException(() -> instance.init(truststore));
        TrustManager[] trustManagers = instance.getTrustManagers();
        X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
        return new TrustManager[]{new SingleHostnameX509TrustManager(trustManager, hostname)};
    }

    static interface RethrowVoidGeneralSecurityException {
        public void run() throws GeneralSecurityException;
    }

    static interface RethrowGeneralSecurityException<T> {
        public static <T> T handleGeneralSecurityException(RethrowGeneralSecurityException<T> operation) {
            try {
                return operation.run();
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
        }

        public static void handleGeneralSecurityException(RethrowVoidGeneralSecurityException operation) {
            RethrowGeneralSecurityException.handleGeneralSecurityException(() -> {
                operation.run();
                return null;
            });
        }

        public T run() throws GeneralSecurityException;
    }
}

