/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhenneaux.resilienthttpclient.singlehostclient;

import com.github.nhenneaux.resilienthttpclient.singlehostclient.HttpClientWrapper;
import com.github.nhenneaux.resilienthttpclient.singlehostclient.SingleHostnameX509TrustManager;
import java.net.InetAddress;
import java.net.http.HttpClient;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SingleHostHttpClientBuilder {
    private final String hostname;
    private final InetAddress hostAddress;
    private final HttpClient.Builder builder;

    private SingleHostHttpClientBuilder(String hostname, InetAddress hostAddress, HttpClient.Builder builder) {
        this.hostname = hostname;
        this.hostAddress = hostAddress;
        this.builder = builder;
    }

    public static HttpClient newHttpClient(String hostname, InetAddress hostAddress) {
        return SingleHostHttpClientBuilder.builder(hostname, hostAddress, HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(2L))).withTlsNameMatching().withSni().buildWithHostHeader();
    }

    public static SingleHostHttpClientBuilder builder(String hostname, InetAddress hostAddress, HttpClient.Builder builder) {
        return new SingleHostHttpClientBuilder(hostname, hostAddress, builder);
    }

    public SingleHostHttpClientBuilder withSni() {
        SSLParameters sslParameters = new SSLParameters();
        sslParameters.setServerNames(Collections.singletonList(new SNIHostName(this.hostname)));
        this.builder.sslParameters(sslParameters);
        return this;
    }

    public SingleHostHttpClientBuilder withTlsNameMatching() {
        return this.withTlsNameMatching((KeyStore)null);
    }

    public SingleHostHttpClientBuilder withTlsNameMatching(KeyStore trustStore) {
        return this.withTlsNameMatching(trustStore, RethrowGeneralSecurityException.handleGeneralSecurityException(() -> SSLContext.getInstance("TLSv1.3")));
    }

    public SingleHostHttpClientBuilder withTlsNameMatching(SSLContext initialSslContext) {
        return this.withTlsNameMatching(null, initialSslContext);
    }

    public SingleHostHttpClientBuilder withTlsNameMatching(KeyStore trustStore, SSLContext initialSslContext) {
        SSLContext sslContextForSingleHostname = SingleHostHttpClientBuilder.buildSslContextForSingleHostname(this.hostname, trustStore, initialSslContext);
        this.builder.sslContext(sslContextForSingleHostname);
        return this;
    }

    public HttpClient buildWithHostHeader() {
        HttpClient client = this.build();
        return SingleHostHttpClientBuilder.isJava13OrHigher().map(ignored -> new HttpClientWrapper(client, this.hostAddress, this.hostname)).map(HttpClient.class::cast).orElse(client);
    }

    public HttpClient build() {
        return new HttpClientWrapper(this.builder.build(), this.hostAddress);
    }

    private static SSLContext buildSslContextForSingleHostname(String hostname, KeyStore truststore, SSLContext initialSslContext) {
        TrustManager[] trustOnlyGivenHostname = SingleHostHttpClientBuilder.singleHostTrustManager(hostname, truststore);
        RethrowGeneralSecurityException.handleGeneralSecurityException(() -> initialSslContext.init(null, trustOnlyGivenHostname, new SecureRandom()));
        return initialSslContext;
    }

    private static Optional<Runtime.Version> isJava13OrHigher() {
        return Optional.of(Runtime.version()).filter(version -> version.feature() >= 13);
    }

    private static TrustManager[] singleHostTrustManager(String hostname, KeyStore truststore) {
        TrustManagerFactory instance = RethrowGeneralSecurityException.handleGeneralSecurityException(() -> TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()));
        RethrowGeneralSecurityException.handleGeneralSecurityException(() -> instance.init(truststore));
        TrustManager[] trustManagers = instance.getTrustManagers();
        X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
        return new TrustManager[]{new SingleHostnameX509TrustManager(trustManager, hostname)};
    }

    static interface RethrowVoidGeneralSecurityException {
        public void run() throws GeneralSecurityException;
    }

    static interface RethrowGeneralSecurityException<T> {
        public static <T> T handleGeneralSecurityException(RethrowGeneralSecurityException<T> operation) {
            try {
                return operation.run();
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException(e);
            }
        }

        public static void handleGeneralSecurityException(RethrowVoidGeneralSecurityException operation) {
            RethrowGeneralSecurityException.handleGeneralSecurityException(() -> {
                operation.run();
                return null;
            });
        }

        public T run() throws GeneralSecurityException;
    }
}

