/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhenneaux.resilienthttpclient.singlehostclient;

import com.github.nhenneaux.resilienthttpclient.singlehostclient.SingleIpHttpRequest;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

public class HttpClientWrapper
extends HttpClient {
    private final HttpClient httpClient;
    private final Function<HttpRequest, SingleIpHttpRequest> requestWrapper;

    HttpClientWrapper(HttpClient httpClient, Function<HttpRequest, SingleIpHttpRequest> requestWrapper) {
        this.httpClient = httpClient;
        this.requestWrapper = requestWrapper;
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return this.httpClient.cookieHandler();
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return this.httpClient.connectTimeout();
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return this.httpClient.followRedirects();
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return this.httpClient.proxy();
    }

    @Override
    public SSLContext sslContext() {
        return this.httpClient.sslContext();
    }

    @Override
    public SSLParameters sslParameters() {
        return this.httpClient.sslParameters();
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return this.httpClient.authenticator();
    }

    @Override
    public HttpClient.Version version() {
        return this.httpClient.version();
    }

    @Override
    public Optional<Executor> executor() {
        return this.httpClient.executor();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        return this.httpClient.send(this.requestWrapper.apply(request), responseBodyHandler);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        return this.httpClient.sendAsync(this.requestWrapper.apply(request), responseBodyHandler);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        return this.httpClient.sendAsync(this.requestWrapper.apply(request), responseBodyHandler, pushPromiseHandler);
    }

    @Override
    public WebSocket.Builder newWebSocketBuilder() {
        return this.httpClient.newWebSocketBuilder();
    }
}

