/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhenneaux.resilienthttpclient.singlehostclient;

import java.util.concurrent.TimeUnit;

public class ServerConfiguration {
    private static final int DEFAULT_PORT = -1;
    private static final String DEFAULT_HEALTH_PATH = "";
    private static final long DEFAULT_DNS_LOOKUP_REFRESH_PERIOD_IN_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    private static final long DEFAULT_CONNECTION_HEALTH_CHECK_PERIOD_IN_SECONDS = 30L;
    private static final long DEFAULT_READ_TIMEOUT_IN_MILLISECONDS = -1L;
    private final String hostname;
    private final int port;
    private final String healthPath;
    private final long connectionHealthCheckPeriodInSeconds;
    private final long dnsLookupRefreshPeriodInSeconds;
    private final long readTimeoutInMilliseconds;

    public ServerConfiguration(String hostname) {
        this(hostname, -1, DEFAULT_HEALTH_PATH, DEFAULT_DNS_LOOKUP_REFRESH_PERIOD_IN_SECONDS, 30L, -1L);
    }

    public ServerConfiguration(String hostname, int port) {
        this(hostname, port, DEFAULT_HEALTH_PATH, DEFAULT_DNS_LOOKUP_REFRESH_PERIOD_IN_SECONDS, 30L, -1L);
    }

    public ServerConfiguration(String hostname, int port, String healthPath, long dnsLookupRefreshPeriodInSeconds, long connectionHealthCheckPeriodInSeconds, long readTimeoutInMilliseconds) {
        this.hostname = hostname;
        this.port = port;
        this.healthPath = healthPath;
        this.connectionHealthCheckPeriodInSeconds = connectionHealthCheckPeriodInSeconds;
        this.dnsLookupRefreshPeriodInSeconds = dnsLookupRefreshPeriodInSeconds;
        this.readTimeoutInMilliseconds = readTimeoutInMilliseconds;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getHealthPath() {
        return this.healthPath;
    }

    public long getDnsLookupRefreshPeriodInSeconds() {
        return this.dnsLookupRefreshPeriodInSeconds;
    }

    public long getConnectionHealthCheckPeriodInSeconds() {
        return this.connectionHealthCheckPeriodInSeconds;
    }

    public long getReadTimeoutInMilliseconds() {
        return this.readTimeoutInMilliseconds;
    }

    public String toString() {
        return "ServerConfiguration{hostname='" + this.hostname + "', port=" + this.port + ", healthPath='" + this.healthPath + "', connectionHealthCheckPeriodInSeconds=" + this.connectionHealthCheckPeriodInSeconds + ", dnsLookupRefreshPeriodInSeconds=" + this.dnsLookupRefreshPeriodInSeconds + ", readTimeoutInMilliseconds=" + this.readTimeoutInMilliseconds + "}";
    }
}

