/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhenneaux.resilienthttpclient.singlehostclient;

import java.net.IDN;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.X509TrustManager;

public class SingleHostnameX509TrustManager
implements X509TrustManager {
    private static final Logger LOGGER = Logger.getLogger(SingleHostnameX509TrustManager.class.getSimpleName());
    private static final int ALTNAME_DNS = 2;
    private final X509TrustManager trustManager;
    private final String hostname;

    protected SingleHostnameX509TrustManager(X509TrustManager trustManager, String hostname) {
        this.trustManager = trustManager;
        this.hostname = hostname;
    }

    static void matchDNS(String expectedName, X509Certificate cert) throws CertificateException {
        String subject;
        try {
            new SNIHostName(expectedName);
        }
        catch (IllegalArgumentException iae) {
            throw new CertificateException("Illegal given domain name: " + expectedName, iae);
        }
        Collection<List<?>> subjAltNames = cert.getSubjectAlternativeNames();
        if (subjAltNames != null) {
            boolean foundDNS = false;
            for (List<?> next : subjAltNames) {
                if ((Integer)next.get(0) != 2) continue;
                foundDNS = true;
                String dnsName = (String)next.get(1);
                if (!SingleHostnameX509TrustManager.isMatched(expectedName, dnsName)) continue;
                return;
            }
            if (foundDNS) {
                throw new CertificateException("No subject alternative DNS name matching " + expectedName + " found.");
            }
        }
        if ((subject = SingleHostnameX509TrustManager.getSubject(cert)) != null && SingleHostnameX509TrustManager.isMatched(expectedName, subject)) {
            return;
        }
        throw new CertificateException("No name matching " + expectedName + " found");
    }

    private static String getSubject(X509Certificate leaf) {
        return Stream.of(leaf).map(cert -> cert.getSubjectX500Principal().getName()).flatMap(name -> {
            LdapName ldapName;
            try {
                ldapName = new LdapName((String)name);
            }
            catch (InvalidNameException e) {
                LOGGER.log(Level.INFO, e, () -> "The name " + name + " is not valid and cannot be parsed as javax.naming.ldap.LdapName");
                return Stream.empty();
            }
            return ldapName.getRdns().stream().filter(rdn -> rdn.getType().equalsIgnoreCase("cn")).map(rdn -> rdn.getValue().toString());
        }).collect(Collectors.joining(", "));
    }

    private static boolean isMatched(String name, String template) {
        try {
            name = IDN.toUnicode(IDN.toASCII(name));
            template = IDN.toUnicode(IDN.toASCII(template));
        }
        catch (RuntimeException re) {
            LOGGER.log(Level.FINE, "Failed to normalize to Unicode.", re);
            return false;
        }
        if (SingleHostnameX509TrustManager.hasIllegalWildcard(template)) {
            return false;
        }
        try {
            new SNIHostName(template.replace('*', 'z'));
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return SingleHostnameX509TrustManager.matchAllWildcards(name, template);
    }

    private static boolean hasIllegalWildcard(String template) {
        if (template.equals("*") || template.equals("*.")) {
            return true;
        }
        int lastWildcardIndex = template.lastIndexOf(42);
        if (lastWildcardIndex == -1) {
            return false;
        }
        String afterWildcard = template.substring(lastWildcardIndex);
        int firstDotIndex = afterWildcard.indexOf(46);
        return firstDotIndex == -1;
    }

    private static boolean matchAllWildcards(String name, String template) {
        name = name.toLowerCase(Locale.ENGLISH);
        template = template.toLowerCase(Locale.ENGLISH);
        StringTokenizer nameSt = new StringTokenizer(name, ".");
        StringTokenizer templateSt = new StringTokenizer(template, ".");
        if (nameSt.countTokens() != templateSt.countTokens()) {
            return false;
        }
        while (nameSt.hasMoreTokens()) {
            if (SingleHostnameX509TrustManager.matchWildCards(nameSt.nextToken(), templateSt.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchWildCards(String name, String template) {
        int wildcardIdx = template.indexOf(42);
        if (wildcardIdx == -1) {
            return name.equals(template);
        }
        boolean isBeginning = true;
        String afterWildcard = template;
        while (wildcardIdx != -1) {
            String beforeWildcard = afterWildcard.substring(0, wildcardIdx);
            afterWildcard = afterWildcard.substring(wildcardIdx + 1);
            int beforeStartIdx = name.indexOf(beforeWildcard);
            if (beforeStartIdx == -1 || isBeginning && beforeStartIdx != 0) {
                return false;
            }
            isBeginning = false;
            name = name.substring(beforeStartIdx + beforeWildcard.length());
            wildcardIdx = afterWildcard.indexOf(42);
        }
        return name.endsWith(afterWildcard);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(certs, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(certs, authType);
        X509Certificate leaf = certs[0];
        SingleHostnameX509TrustManager.matchDNS(this.hostname, leaf);
    }
}

