/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhenneaux.resilienthttpclient.singlehostclient;

import java.net.http.HttpRequest;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ServerConfiguration {
    public static final int DEFAULT_PORT = -1;
    public static final String DEFAULT_HEALTH_PATH = "";
    public static final long DEFAULT_DNS_LOOKUP_REFRESH_PERIOD_IN_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    public static final long DEFAULT_CONNECTION_HEALTH_CHECK_PERIOD_IN_SECONDS = 30L;
    public static final long DEFAULT_HEALTH_READ_TIMEOUT_IN_MILLISECONDS = TimeUnit.SECONDS.toMillis(5L);
    public static final int DEFAULT_FAILURE_RESPONSE_COUNT_THRESHOLD = -1;
    public static final Consumer<HttpRequest.Builder> DEFAULT_REQUEST_TRANSFORMER = null;
    public static final String DEFAULT_PROTOCOL = "https";
    public static final Set<String> SUPPORTED_PROTOCOLS = Set.of("http", "https");
    private final String hostname;
    private final int port;
    private final String healthPath;
    private final long connectionHealthCheckPeriodInSeconds;
    private final long dnsLookupRefreshPeriodInSeconds;
    private final long healthReadTimeoutInMilliseconds;
    private final int failureResponseCountThreshold;
    private final Consumer<HttpRequest.Builder> requestTransformer;
    private final String protocol;

    public ServerConfiguration(String hostname) {
        this(hostname, -1, DEFAULT_HEALTH_PATH, DEFAULT_DNS_LOOKUP_REFRESH_PERIOD_IN_SECONDS, 30L, DEFAULT_HEALTH_READ_TIMEOUT_IN_MILLISECONDS, -1, DEFAULT_REQUEST_TRANSFORMER, DEFAULT_PROTOCOL);
    }

    public ServerConfiguration(String hostname, int port) {
        this(hostname, port, DEFAULT_HEALTH_PATH, DEFAULT_DNS_LOOKUP_REFRESH_PERIOD_IN_SECONDS, 30L, DEFAULT_HEALTH_READ_TIMEOUT_IN_MILLISECONDS, -1, DEFAULT_REQUEST_TRANSFORMER, DEFAULT_PROTOCOL);
    }

    public ServerConfiguration(String hostname, int port, String healthPath, long dnsLookupRefreshPeriodInSeconds, long connectionHealthCheckPeriodInSeconds, long healthReadTimeoutInMilliseconds, int failureResponseCountThreshold, Consumer<HttpRequest.Builder> requestTransformer) {
        this(hostname, port, healthPath, dnsLookupRefreshPeriodInSeconds, connectionHealthCheckPeriodInSeconds, healthReadTimeoutInMilliseconds, failureResponseCountThreshold, requestTransformer, DEFAULT_PROTOCOL);
    }

    public ServerConfiguration(String hostname, int port, String healthPath, long dnsLookupRefreshPeriodInSeconds, long connectionHealthCheckPeriodInSeconds, long healthReadTimeoutInMilliseconds, int failureResponseCountThreshold, Consumer<HttpRequest.Builder> requestTransformer, String protocol) {
        this.hostname = hostname;
        this.port = port;
        this.healthPath = healthPath;
        this.connectionHealthCheckPeriodInSeconds = connectionHealthCheckPeriodInSeconds;
        this.dnsLookupRefreshPeriodInSeconds = dnsLookupRefreshPeriodInSeconds;
        this.healthReadTimeoutInMilliseconds = healthReadTimeoutInMilliseconds;
        this.failureResponseCountThreshold = failureResponseCountThreshold;
        this.requestTransformer = requestTransformer;
        if (protocol == null || !SUPPORTED_PROTOCOLS.contains(protocol)) {
            throw new IllegalArgumentException("Supported protocols are http or https, but was: " + protocol);
        }
        this.protocol = protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getHealthPath() {
        return this.healthPath;
    }

    public long getDnsLookupRefreshPeriodInSeconds() {
        return this.dnsLookupRefreshPeriodInSeconds;
    }

    public long getConnectionHealthCheckPeriodInSeconds() {
        return this.connectionHealthCheckPeriodInSeconds;
    }

    public long getHealthReadTimeoutInMilliseconds() {
        return this.healthReadTimeoutInMilliseconds;
    }

    public int getFailureResponseCountThreshold() {
        return this.failureResponseCountThreshold;
    }

    public Consumer<HttpRequest.Builder> getRequestTransformer() {
        return this.requestTransformer;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return "ServerConfiguration{hostname='" + this.hostname + "', port=" + this.port + ", healthPath='" + this.healthPath + "', connectionHealthCheckPeriodInSeconds=" + this.connectionHealthCheckPeriodInSeconds + ", dnsLookupRefreshPeriodInSeconds=" + this.dnsLookupRefreshPeriodInSeconds + ", healthReadTimeoutInMilliseconds=" + this.healthReadTimeoutInMilliseconds + ", failureResponseCountThreshold= " + this.failureResponseCountThreshold + ", protocol= " + this.protocol + "}";
    }
}

