/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhojpatrick.hamcrest.datetime;

import com.github.nhojpatrick.hamcrest.datetime.flags.CompareType;
import com.github.nhojpatrick.hamcrest.datetime.flags.RoundingType;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeLocalDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeOffsetDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeZonedDateTime;
import java.time.OffsetDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IsBeforeDateTime {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsBeforeDateTime.class);

    public static <T> Matcher<T> beforeLocalDateTime(ChronoLocalDateTime expected) {
        LOGGER.debug("IsBeforeTime#beforeLocalDateTime((Before) {})", (Object)expected);
        return IsBeforeDateTime.doBeforeLocalDateTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeLocalDateTime(ChronoLocalDateTime expected, CompareType compareType) {
        LOGGER.debug("IsBeforeTime#beforeLocalDateTime((Before) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsBeforeDateTime.doBeforeLocalDateTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeLocalDateTime(ChronoLocalDateTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeLocalDateTime((Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsBeforeDateTime.doBeforeLocalDateTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> beforeLocalDateTime(ChronoLocalDateTime expected, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeLocalDateTime((Before) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsBeforeDateTime.doBeforeLocalDateTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    public static <T> Matcher<T> beforeOffsetDateTime(OffsetDateTime expected) {
        LOGGER.debug("IsBeforeTime#beforeOffsetDateTime((Before) {})", (Object)expected);
        return IsBeforeDateTime.doBeforeOffsetDateTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeOffsetDateTime(OffsetDateTime expected, CompareType compareType) {
        LOGGER.debug("IsBeforeTime#beforeOffsetDateTime((Before) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsBeforeDateTime.doBeforeOffsetDateTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeOffsetDateTime(OffsetDateTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeOffsetDateTime((Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsBeforeDateTime.doBeforeOffsetDateTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> beforeOffsetDateTime(OffsetDateTime expected, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeOffsetDateTime((Before) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsBeforeDateTime.doBeforeOffsetDateTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    private static <T> Matcher<T> doBeforeOffsetDateTime(OffsetDateTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsBeforeOffsetDateTime<OffsetDateTime>(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> beforeZonedDateTime(ChronoZonedDateTime expected) {
        LOGGER.debug("IsBeforeTime#beforeZonedDateTime((Before) {})", (Object)expected);
        return IsBeforeDateTime.doBeforeZonedDateTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeZonedDateTime(ChronoZonedDateTime expected, CompareType compareType) {
        LOGGER.debug("IsBeforeTime#beforeZonedDateTime((Before) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsBeforeDateTime.doBeforeZonedDateTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeZonedDateTime(ChronoZonedDateTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeZonedDateTime((Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsBeforeDateTime.doBeforeZonedDateTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> beforeZonedDateTime(ChronoZonedDateTime expected, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeZonedDateTime((Before) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsBeforeDateTime.doBeforeZonedDateTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    private static <T> Matcher<T> doBeforeLocalDateTime(ChronoLocalDateTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsBeforeLocalDateTime<ChronoLocalDateTime>(expected, compareType, roundingType);
    }

    private static <T> Matcher<T> doBeforeZonedDateTime(ChronoZonedDateTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsBeforeZonedDateTime<ChronoZonedDateTime>(expected, compareType, roundingType);
    }

    IsBeforeDateTime() {
        throw new AssertionError((Object)"Static utility class - cannot be instantiated.");
    }
}

