/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhojpatrick.hamcrest.datetime;

import com.github.nhojpatrick.hamcrest.datetime.flags.CompareType;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterLocalDate;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeLocalDate;
import java.time.LocalDate;
import org.hamcrest.Matcher;
import org.hamcrest.core.CombinableMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IsBetweenDate {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsBetweenDate.class);

    public static <T> Matcher<T> betweenLocalDate(LocalDate after, LocalDate before) {
        LOGGER.debug("IsBetweenDate#betweenLocalDate((After) {}, (Before) {})", (Object)after, (Object)before);
        return IsBetweenDate.doBetweenLocalDate(after, CompareType.EXCLUSIVE, before, CompareType.EXCLUSIVE);
    }

    public static <T> Matcher<T> betweenLocalDate(LocalDate after, CompareType afterCompareType, LocalDate before, CompareType beforeCompareType) {
        LOGGER.debug("IsBetweenDate#betweenLocalDate((After) {}, (CompareType) {}, (Before) {}, (CompareType) {})", new Object[]{after, afterCompareType, before, beforeCompareType});
        return IsBetweenDate.doBetweenLocalDate(after, afterCompareType, before, beforeCompareType);
    }

    private static <T> Matcher<T> doBetweenLocalDate(LocalDate after, CompareType afterCompareType, LocalDate before, CompareType beforeCompareType) {
        CombinableMatcher betweenLocalDate = CombinableMatcher.both(new IsAfterLocalDate<LocalDate>(after, afterCompareType)).and(new IsBeforeLocalDate<LocalDate>(before, beforeCompareType));
        if (after.isEqual(before)) {
            throw new IllegalStateException(String.format("After <%s> must not equal Before <%s>.", after, before));
        }
        if (after.isAfter(before) || before.isBefore(after)) {
            throw new IllegalStateException(String.format("After <%s> must be Before <%s>.", after, before));
        }
        return betweenLocalDate;
    }

    IsBetweenDate() {
        throw new AssertionError((Object)"Static utility class - cannot be instantiated.");
    }
}

