/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhojpatrick.hamcrest.datetime;

import com.github.nhojpatrick.hamcrest.datetime.internal.equals.IsLocalDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.equals.IsOffsetDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.equals.IsZonedDateTime;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IsDateTime {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsDateTime.class);

    public static <T> Matcher<T> localDateTime() {
        LOGGER.debug("IsDateTime#localDateTime()");
        return IsInstanceOf.instanceOf(LocalDateTime.class);
    }

    public static <T> Matcher<T> localDateTime(Matcher<T> matcher) {
        LOGGER.debug("IsDateTime#localDateTime((Matcher<T>) {})", matcher);
        return new IsLocalDateTime<T>(matcher);
    }

    public static <T> Matcher<T> offsetDateTime() {
        LOGGER.debug("IsDateTime#offsetDateTime()");
        return IsInstanceOf.instanceOf(OffsetDateTime.class);
    }

    public static <T> Matcher<T> offsetDateTime(Matcher<T> matcher) {
        LOGGER.debug("IsDateTime#offsetDateTime((Matcher<T>) {})", matcher);
        return new IsOffsetDateTime<T>(matcher);
    }

    public static <T> Matcher<T> zonedDateTime() {
        LOGGER.debug("IsDateTime#zonedDateTime()");
        return IsInstanceOf.instanceOf(ZonedDateTime.class);
    }

    public static <T> Matcher<T> zonedDateTime(Matcher<T> matcher) {
        LOGGER.debug("IsDateTime#zonedDateTime((Matcher<T>) {})", matcher);
        return new IsZonedDateTime<T>(matcher);
    }

    IsDateTime() {
        throw new AssertionError((Object)"Static utility class - cannot be instantiated.");
    }
}

