/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhojpatrick.hamcrest.datetime.internal.before;

import com.github.nhojpatrick.hamcrest.datetime.flags.CompareType;
import com.github.nhojpatrick.hamcrest.datetime.flags.RoundingType;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractIsBefore<T extends Temporal>
extends TypeSafeMatcher<T> {
    public static final String SUPPLIED_COMPARE_TYPE_MUST_NOT_BE_NULL = "Supplied Before CompareType must not be null";
    public static final String SUPPLIED_EXPECTED_MUST_NOT_BE_NULL = "Supplied Before must not be null";
    public static final String SUPPLIED_ROUNDING_TYPE_MUST_NOT_BE_NULL = "Supplied RoundingType must not be null";
    protected final T before;
    protected final CompareType compareType;

    protected AbstractIsBefore(T before, CompareType compareType, RoundingType roundingType) {
        if (Objects.isNull(before)) {
            throw new IllegalArgumentException(SUPPLIED_EXPECTED_MUST_NOT_BE_NULL);
        }
        if (Objects.isNull((Object)compareType)) {
            throw new IllegalArgumentException(SUPPLIED_COMPARE_TYPE_MUST_NOT_BE_NULL);
        }
        if (Objects.isNull((Object)roundingType)) {
            throw new IllegalArgumentException(SUPPLIED_ROUNDING_TYPE_MUST_NOT_BE_NULL);
        }
        switch (roundingType) {
            case DOWN: {
                this.before = before.with(ChronoField.NANO_OF_SECOND, 0L);
                break;
            }
            case UP: {
                this.before = before.with(ChronoField.NANO_OF_SECOND, 999999999L);
                break;
            }
            default: {
                this.before = before;
            }
        }
        this.compareType = compareType;
    }

    public void describeTo(Description description) {
        switch (this.compareType) {
            case INCLUSIVE: {
                description.appendText("before or equal to ").appendValue(this.before);
                break;
            }
            default: {
                description.appendText("before ").appendValue(this.before);
            }
        }
    }
}

