/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhojpatrick.hamcrest.datetime;

import com.github.nhojpatrick.hamcrest.datetime.flags.CompareType;
import com.github.nhojpatrick.hamcrest.datetime.flags.RoundingType;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterLocalDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterOffsetDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterZonedDateTime;
import java.time.OffsetDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IsAfterDateTime {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsAfterDateTime.class);

    public static <T> Matcher<T> afterLocalDateTime(ChronoLocalDateTime expected) {
        LOGGER.debug("IsAfterTime#afterLocalDateTime((After) {})", (Object)expected);
        return IsAfterDateTime.doAfterLocalDateTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterLocalDateTime(ChronoLocalDateTime expected, CompareType compareType) {
        LOGGER.debug("IsAfterTime#afterLocalDateTime((After) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsAfterDateTime.doAfterLocalDateTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterLocalDateTime(ChronoLocalDateTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterLocalDateTime((After) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsAfterDateTime.doAfterLocalDateTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> afterLocalDateTime(ChronoLocalDateTime expected, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterLocalDateTime((After) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsAfterDateTime.doAfterLocalDateTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    public static <T> Matcher<T> afterOffsetDateTime(OffsetDateTime expected) {
        LOGGER.debug("IsAfterTime#afterOffsetDateTime((After) {})", (Object)expected);
        return IsAfterDateTime.doAfterOffsetDateTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterOffsetDateTime(OffsetDateTime expected, CompareType compareType) {
        LOGGER.debug("IsAfterTime#afterOffsetDateTime((After) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsAfterDateTime.doAfterOffsetDateTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterOffsetDateTime(OffsetDateTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterOffsetDateTime((After) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsAfterDateTime.doAfterOffsetDateTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> afterOffsetDateTime(OffsetDateTime expected, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterOffsetDateTime((After) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsAfterDateTime.doAfterOffsetDateTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    private static <T> Matcher<T> doAfterOffsetDateTime(OffsetDateTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsAfterOffsetDateTime<OffsetDateTime>(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> afterZonedDateTime(ChronoZonedDateTime expected) {
        LOGGER.debug("IsAfterTime#afterZonedDateTime((After) {})", (Object)expected);
        return IsAfterDateTime.doAfterZonedDateTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterZonedDateTime(ChronoZonedDateTime expected, CompareType compareType) {
        LOGGER.debug("IsAfterTime#afterZonedDateTime((After) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsAfterDateTime.doAfterZonedDateTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterZonedDateTime(ChronoZonedDateTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterZonedDateTime((After) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsAfterDateTime.doAfterZonedDateTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> afterZonedDateTime(ChronoZonedDateTime expected, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterZonedDateTime((After) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsAfterDateTime.doAfterZonedDateTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    private static <T> Matcher<T> doAfterLocalDateTime(ChronoLocalDateTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsAfterLocalDateTime<ChronoLocalDateTime>(expected, compareType, roundingType);
    }

    private static <T> Matcher<T> doAfterZonedDateTime(ChronoZonedDateTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsAfterZonedDateTime<ChronoZonedDateTime>(expected, compareType, roundingType);
    }

    IsAfterDateTime() {
        throw new AssertionError((Object)"Static utility class - cannot be instantiated.");
    }
}

