/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhojpatrick.hamcrest.datetime;

import com.github.nhojpatrick.hamcrest.datetime.flags.CompareType;
import com.github.nhojpatrick.hamcrest.datetime.flags.RoundingType;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterLocalTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterOffsetTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IsAfterTime {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsAfterTime.class);

    public static <T> Matcher<T> afterLocalTime(LocalTime expected) {
        LOGGER.debug("IsAfterTime#afterLocalTime((After) {})", (Object)expected);
        return IsAfterTime.doAfterLocalTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterLocalTime(LocalTime expected, CompareType compareType) {
        LOGGER.debug("IsAfterTime#afterLocalTime((After) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsAfterTime.doAfterLocalTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterLocalTime(LocalTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterLocalTime((After) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsAfterTime.doAfterLocalTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> afterLocalTime(LocalTime expected, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterLocalTime((After) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsAfterTime.doAfterLocalTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    public static <T> Matcher<T> afterOffsetTime(OffsetTime expected) {
        LOGGER.debug("IsAfterTime#afterOffsetTime((After) {})", (Object)expected);
        return IsAfterTime.doAfterOffsetTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterOffsetTime(OffsetTime expected, CompareType compareType) {
        LOGGER.debug("IsAfterTime#afterOffsetTime((After) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsAfterTime.doAfterOffsetTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> afterOffsetTime(OffsetTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterOffsetTime((After) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsAfterTime.doAfterOffsetTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> afterOffsetTime(OffsetTime expected, RoundingType roundingType) {
        LOGGER.debug("IsAfterTime#afterOffsetTime((After) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsAfterTime.doAfterOffsetTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    private static <T> Matcher<T> doAfterLocalTime(LocalTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsAfterLocalTime<LocalTime>(expected, compareType, roundingType);
    }

    private static <T> Matcher<T> doAfterOffsetTime(OffsetTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsAfterOffsetTime<OffsetTime>(expected, compareType, roundingType);
    }

    IsAfterTime() {
        throw new AssertionError((Object)"Static utility class - cannot be instantiated.");
    }
}

