/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhojpatrick.hamcrest.datetime;

import com.github.nhojpatrick.hamcrest.datetime.flags.CompareType;
import com.github.nhojpatrick.hamcrest.datetime.flags.RoundingType;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeLocalTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeOffsetTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IsBeforeTime {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsBeforeTime.class);

    public static <T> Matcher<T> beforeLocalTime(LocalTime expected) {
        LOGGER.debug("IsBeforeTime#beforeLocalTime((Before) {})", (Object)expected);
        return IsBeforeTime.doBeforeLocalTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeLocalTime(LocalTime expected, CompareType compareType) {
        LOGGER.debug("IsBeforeTime#beforeLocalTime((Before) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsBeforeTime.doBeforeLocalTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeLocalTime(LocalTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeLocalTime((Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsBeforeTime.doBeforeLocalTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> beforeLocalTime(LocalTime expected, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeLocalTime((Before) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsBeforeTime.doBeforeLocalTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    public static <T> Matcher<T> beforeOffsetTime(OffsetTime expected) {
        LOGGER.debug("IsBeforeTime#beforeOffsetTime((Before) {})", (Object)expected);
        return IsBeforeTime.doBeforeOffsetTime(expected, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeOffsetTime(OffsetTime expected, CompareType compareType) {
        LOGGER.debug("IsBeforeTime#beforeOffsetTime((Before) {}, (CompareType) {})", (Object)expected, (Object)compareType);
        return IsBeforeTime.doBeforeOffsetTime(expected, compareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> beforeOffsetTime(OffsetTime expected, CompareType compareType, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeOffsetTime((Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{expected, compareType, roundingType});
        return IsBeforeTime.doBeforeOffsetTime(expected, compareType, roundingType);
    }

    public static <T> Matcher<T> beforeOffsetTime(OffsetTime expected, RoundingType roundingType) {
        LOGGER.debug("IsBeforeTime#beforeOffsetTime((Before) {}, (RoundingType) {})", (Object)expected, (Object)roundingType);
        return IsBeforeTime.doBeforeOffsetTime(expected, CompareType.EXCLUSIVE, roundingType);
    }

    private static <T> Matcher<T> doBeforeLocalTime(LocalTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsBeforeLocalTime<LocalTime>(expected, compareType, roundingType);
    }

    private static <T> Matcher<T> doBeforeOffsetTime(OffsetTime expected, CompareType compareType, RoundingType roundingType) {
        return new IsBeforeOffsetTime<OffsetTime>(expected, compareType, roundingType);
    }

    IsBeforeTime() {
        throw new AssertionError((Object)"Static utility class - cannot be instantiated.");
    }
}

