/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhojpatrick.hamcrest.datetime;

import com.github.nhojpatrick.hamcrest.datetime.flags.CompareType;
import com.github.nhojpatrick.hamcrest.datetime.flags.RoundingType;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterLocalDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterOffsetDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterZonedDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeLocalDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeOffsetDateTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeZonedDateTime;
import java.time.OffsetDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import org.hamcrest.Matcher;
import org.hamcrest.core.CombinableMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IsBetweenDateTime {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsBetweenDateTime.class);

    public static <T> Matcher<T> betweenLocalDateTime(ChronoLocalDateTime after, ChronoLocalDateTime before) {
        LOGGER.debug("IsBetweenTime#betweenLocalDateTime((After) {}, (Before) {})", (Object)after, (Object)before);
        return IsBetweenDateTime.doBetweenLocalDateTime(after, CompareType.EXCLUSIVE, RoundingType.NONE, before, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenLocalDateTime(ChronoLocalDateTime after, CompareType afterCompareType, ChronoLocalDateTime before, CompareType beforeCompareType) {
        LOGGER.debug("IsBetweenTime#betweenLocalDateTime((After) {}, (CompareType) {}, (Before) {}, (CompareType) {})", new Object[]{after, afterCompareType, before, beforeCompareType});
        return IsBetweenDateTime.doBetweenLocalDateTime(after, afterCompareType, RoundingType.NONE, before, beforeCompareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenLocalDateTime(ChronoLocalDateTime after, CompareType afterCompareType, RoundingType afterRoundingType, ChronoLocalDateTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenLocalDateTime((After) {}, (CompareType) {}, (RoundingType) {}, (Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType});
        return IsBetweenDateTime.doBetweenLocalDateTime(after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType);
    }

    public static <T> Matcher<T> betweenLocalDateTime(ChronoLocalDateTime after, RoundingType afterRoundingType, ChronoLocalDateTime before, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenLocalDateTime((After) {}, (RoundingType) {}, (Before) {}, (RoundingType) {})", new Object[]{after, afterRoundingType, before, beforeRoundingType});
        return IsBetweenDateTime.doBetweenLocalDateTime(after, CompareType.EXCLUSIVE, afterRoundingType, before, CompareType.EXCLUSIVE, beforeRoundingType);
    }

    public static <T> Matcher<T> betweenOffsetDateTime(OffsetDateTime after, OffsetDateTime before) {
        LOGGER.debug("IsBetweenTime#betweenOffsetDateTime((After) {}, (Before) {})", (Object)after, (Object)before);
        return IsBetweenDateTime.doBetweenOffsetDateTime(after, CompareType.EXCLUSIVE, RoundingType.NONE, before, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenOffsetDateTime(OffsetDateTime after, CompareType afterCompareType, OffsetDateTime before, CompareType beforeCompareType) {
        LOGGER.debug("IsBetweenTime#betweenOffsetDateTime((After) {}, (CompareType) {}, (Before) {}, (CompareType) {})", new Object[]{after, afterCompareType, before, beforeCompareType});
        return IsBetweenDateTime.doBetweenOffsetDateTime(after, afterCompareType, RoundingType.NONE, before, beforeCompareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenOffsetDateTime(OffsetDateTime after, CompareType afterCompareType, RoundingType afterRoundingType, OffsetDateTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenOffsetDateTime((After) {}, (CompareType) {}, (RoundingType) {}, (Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType});
        return IsBetweenDateTime.doBetweenOffsetDateTime(after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType);
    }

    public static <T> Matcher<T> betweenOffsetDateTime(OffsetDateTime after, RoundingType afterRoundingType, OffsetDateTime before, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenOffsetDateTime((After) {}, (RoundingType) {}, (Before) {}, (RoundingType) {})", new Object[]{after, afterRoundingType, before, beforeRoundingType});
        return IsBetweenDateTime.doBetweenOffsetDateTime(after, CompareType.EXCLUSIVE, afterRoundingType, before, CompareType.EXCLUSIVE, beforeRoundingType);
    }

    public static <T> Matcher<T> betweenZonedDateTime(ChronoZonedDateTime after, ChronoZonedDateTime before) {
        LOGGER.debug("IsBetweenTime#betweenZonedDateTime((After) {}, (Before) {})", (Object)after, (Object)before);
        return IsBetweenDateTime.doBetweenZonedDateTime(after, CompareType.EXCLUSIVE, RoundingType.NONE, before, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenZonedDateTime(ChronoZonedDateTime after, CompareType afterCompareType, ChronoZonedDateTime before, CompareType beforeCompareType) {
        LOGGER.debug("IsBetweenTime#betweenZonedDateTime((After) {}, (CompareType) {}, (Before) {}, (CompareType) {})", new Object[]{after, afterCompareType, before, beforeCompareType});
        return IsBetweenDateTime.doBetweenZonedDateTime(after, afterCompareType, RoundingType.NONE, before, beforeCompareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenZonedDateTime(ChronoZonedDateTime after, CompareType afterCompareType, RoundingType afterRoundingType, ChronoZonedDateTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenZonedDateTime((After) {}, (CompareType) {}, (RoundingType) {}, (Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType});
        return IsBetweenDateTime.doBetweenZonedDateTime(after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType);
    }

    public static <T> Matcher<T> betweenZonedDateTime(ChronoZonedDateTime after, RoundingType afterRoundingType, ChronoZonedDateTime before, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenZonedDateTime((After) {}, (RoundingType) {}, (Before) {}, (RoundingType) {})", new Object[]{after, afterRoundingType, before, beforeRoundingType});
        return IsBetweenDateTime.doBetweenZonedDateTime(after, CompareType.EXCLUSIVE, afterRoundingType, before, CompareType.EXCLUSIVE, beforeRoundingType);
    }

    private static <T> Matcher<T> doBetweenLocalDateTime(ChronoLocalDateTime after, CompareType afterCompareType, RoundingType afterRoundingType, ChronoLocalDateTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        CombinableMatcher betweenLocalDateTime = CombinableMatcher.both(new IsAfterLocalDateTime<ChronoLocalDateTime>(after, afterCompareType, afterRoundingType)).and(new IsBeforeLocalDateTime<ChronoLocalDateTime>(before, beforeCompareType, beforeRoundingType));
        if (after.equals(before)) {
            throw new IllegalStateException(String.format("After <%s> must not equal Before <%s>.", after, before));
        }
        if (after.isAfter(before) || before.isBefore(after)) {
            throw new IllegalStateException(String.format("After <%s> must be Before <%s>.", after, before));
        }
        return betweenLocalDateTime;
    }

    private static <T> Matcher<T> doBetweenOffsetDateTime(OffsetDateTime after, CompareType afterCompareType, RoundingType afterRoundingType, OffsetDateTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        CombinableMatcher betweenOffsetDateTime = CombinableMatcher.both(new IsAfterOffsetDateTime<OffsetDateTime>(after, afterCompareType, afterRoundingType)).and(new IsBeforeOffsetDateTime<OffsetDateTime>(before, beforeCompareType, beforeRoundingType));
        if (after.equals(before)) {
            throw new IllegalStateException(String.format("After <%s> must not equal Before <%s>.", after, before));
        }
        if (after.isAfter(before) || before.isBefore(after)) {
            throw new IllegalStateException(String.format("After <%s> must be Before <%s>.", after, before));
        }
        return betweenOffsetDateTime;
    }

    private static <T> Matcher<T> doBetweenZonedDateTime(ChronoZonedDateTime after, CompareType afterCompareType, RoundingType afterRoundingType, ChronoZonedDateTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        CombinableMatcher betweenZonedDateTime = CombinableMatcher.both(new IsAfterZonedDateTime<ChronoZonedDateTime>(after, afterCompareType, afterRoundingType)).and(new IsBeforeZonedDateTime<ChronoZonedDateTime>(before, beforeCompareType, beforeRoundingType));
        if (after.equals(before)) {
            throw new IllegalStateException(String.format("After <%s> must not equal Before <%s>.", after, before));
        }
        if (after.isAfter(before) || before.isBefore(after)) {
            throw new IllegalStateException(String.format("After <%s> must be Before <%s>.", after, before));
        }
        return betweenZonedDateTime;
    }

    IsBetweenDateTime() {
        throw new AssertionError((Object)"Static utility class - cannot be instantiated.");
    }
}

