/*
 * Decompiled with CFR 0.152.
 */
package com.github.nhojpatrick.hamcrest.datetime;

import com.github.nhojpatrick.hamcrest.datetime.flags.CompareType;
import com.github.nhojpatrick.hamcrest.datetime.flags.RoundingType;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterLocalTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.after.IsAfterOffsetTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeLocalTime;
import com.github.nhojpatrick.hamcrest.datetime.internal.before.IsBeforeOffsetTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import org.hamcrest.Matcher;
import org.hamcrest.core.CombinableMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class IsBetweenTime {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsBetweenTime.class);

    public static <T> Matcher<T> betweenLocalTime(LocalTime after, LocalTime before) {
        LOGGER.debug("IsBetweenTime#betweenLocalTime((After) {}, (Before) {})", (Object)after, (Object)before);
        return IsBetweenTime.doBetweenLocalTime(after, CompareType.EXCLUSIVE, RoundingType.NONE, before, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenLocalTime(LocalTime after, CompareType afterCompareType, LocalTime before, CompareType beforeCompareType) {
        LOGGER.debug("IsBetweenTime#betweenLocalTime((After) {}, (CompareType) {}, (Before) {}, (CompareType) {})", new Object[]{after, afterCompareType, before, beforeCompareType});
        return IsBetweenTime.doBetweenLocalTime(after, afterCompareType, RoundingType.NONE, before, beforeCompareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenLocalTime(LocalTime after, CompareType afterCompareType, RoundingType afterRoundingType, LocalTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenLocalTime((After) {}, (CompareType) {}, (RoundingType) {}, (Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType});
        return IsBetweenTime.doBetweenLocalTime(after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType);
    }

    public static <T> Matcher<T> betweenLocalTime(LocalTime after, RoundingType afterRoundingType, LocalTime before, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenLocalTime((After) {}, (RoundingType) {}, (Before) {}, (RoundingType) {})", new Object[]{after, afterRoundingType, before, beforeRoundingType});
        return IsBetweenTime.doBetweenLocalTime(after, CompareType.EXCLUSIVE, afterRoundingType, before, CompareType.EXCLUSIVE, beforeRoundingType);
    }

    public static <T> Matcher<T> betweenOffsetTime(OffsetTime after, OffsetTime before) {
        LOGGER.debug("IsBetweenTime#betweenOffsetTime((After) {}, (Before) {})", (Object)after, (Object)before);
        return IsBetweenTime.doBetweenOffsetTime(after, CompareType.EXCLUSIVE, RoundingType.NONE, before, CompareType.EXCLUSIVE, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenOffsetTime(OffsetTime after, CompareType afterCompareType, OffsetTime before, CompareType beforeCompareType) {
        LOGGER.debug("IsBetweenTime#betweenOffsetTime((After) {}, (CompareType) {}, (Before) {}, (CompareType) {})", new Object[]{after, afterCompareType, before, beforeCompareType});
        return IsBetweenTime.doBetweenOffsetTime(after, afterCompareType, RoundingType.NONE, before, beforeCompareType, RoundingType.NONE);
    }

    public static <T> Matcher<T> betweenOffsetTime(OffsetTime after, CompareType afterCompareType, RoundingType afterRoundingType, OffsetTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenOffsetTime((After) {}, (CompareType) {}, (RoundingType) {}, (Before) {}, (CompareType) {}, (RoundingType) {})", new Object[]{after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType});
        return IsBetweenTime.doBetweenOffsetTime(after, afterCompareType, afterRoundingType, before, beforeCompareType, beforeRoundingType);
    }

    public static <T> Matcher<T> betweenOffsetTime(OffsetTime after, RoundingType afterRoundingType, OffsetTime before, RoundingType beforeRoundingType) {
        LOGGER.debug("IsBetweenTime#betweenOffsetTime((After) {}, (RoundingType) {}, (Before) {}, (RoundingType) {})", new Object[]{after, afterRoundingType, before, beforeRoundingType});
        return IsBetweenTime.doBetweenOffsetTime(after, CompareType.EXCLUSIVE, afterRoundingType, before, CompareType.EXCLUSIVE, beforeRoundingType);
    }

    private static <T> Matcher<T> doBetweenLocalTime(LocalTime after, CompareType afterCompareType, RoundingType afterRoundingType, LocalTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        CombinableMatcher betweenLocalTime = CombinableMatcher.both(new IsAfterLocalTime<LocalTime>(after, afterCompareType, afterRoundingType)).and(new IsBeforeLocalTime<LocalTime>(before, beforeCompareType, beforeRoundingType));
        if (after.equals(before)) {
            throw new IllegalStateException(String.format("After <%s> must not equal Before <%s>.", after, before));
        }
        if (after.isAfter(before) || before.isBefore(after)) {
            throw new IllegalStateException(String.format("After <%s> must be Before <%s>.", after, before));
        }
        return betweenLocalTime;
    }

    private static <T> Matcher<T> doBetweenOffsetTime(OffsetTime after, CompareType afterCompareType, RoundingType afterRoundingType, OffsetTime before, CompareType beforeCompareType, RoundingType beforeRoundingType) {
        CombinableMatcher betweenOffsetTime = CombinableMatcher.both(new IsAfterOffsetTime<OffsetTime>(after, afterCompareType, afterRoundingType)).and(new IsBeforeOffsetTime<OffsetTime>(before, beforeCompareType, beforeRoundingType));
        if (after.equals(before)) {
            throw new IllegalStateException(String.format("After <%s> must not equal Before <%s>.", after, before));
        }
        if (after.isAfter(before) || before.isBefore(after)) {
            throw new IllegalStateException(String.format("After <%s> must be Before <%s>.", after, before));
        }
        return betweenOffsetTime;
    }

    IsBetweenTime() {
        throw new AssertionError((Object)"Static utility class - cannot be instantiated.");
    }
}

