/*
 * Decompiled with CFR 0.152.
 */
package com.github.nomou.spreadsheet;

import com.github.nomou.spreadsheet.SpreadsheetException;
import com.github.nomou.spreadsheet.SpreadsheetParser;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class AbstractSpreadsheetParser
implements SpreadsheetParser {
    protected int eventType;
    protected int worksheetIndex = -1;
    protected String worksheetName;

    @Override
    public int getEventType() {
        return this.eventType;
    }

    @Override
    public int getWorksheetIndex() {
        int st = this.eventType;
        if (11 == st || 12 == st) {
            throw new IllegalStateException("getWorksheetIndex() called in illegal state");
        }
        return this.worksheetIndex;
    }

    @Override
    public String getWorksheetName() {
        int st = this.eventType;
        if (11 == st || 12 == st) {
            throw new IllegalStateException("getWorksheetName() called in illegal state");
        }
        return this.worksheetName;
    }

    @Override
    public boolean hasNext() {
        return -1 != this.eventType && 12 != this.eventType;
    }

    @Override
    public int next() throws SpreadsheetException {
        int t = this.eventType;
        if (!this.hasNext()) {
            if (-1 != t) {
                throw new NoSuchElementException("END_WORKBOOK reached: no more elements on the stream.");
            }
            throw new IllegalStateException("Error processing input source. The input stream is not complete.");
        }
        this.eventType = this.doNext();
        return this.eventType;
    }

    @Override
    public Object[] nextRecord(boolean ignoreEmptyRecord) throws SpreadsheetException {
        AbstractSpreadsheetParser parser = this;
        ArrayList<Object> values = new ArrayList<Object>();
        boolean noMoreRecord = true;
        while (parser.hasNext()) {
            int event = parser.next();
            if (42 == event) {
                noMoreRecord = false;
                int col = parser.getCol();
                Object value = parser.getValue();
                if (col < values.size() - 1) {
                    throw new IllegalStateException("illegal column: " + col);
                }
                if (null == value) continue;
                this.fillNull(values, col - values.size());
                values.add(value);
                continue;
            }
            if (32 != event) continue;
            if (!ignoreEmptyRecord || !values.isEmpty()) {
                noMoreRecord = false;
                break;
            }
            noMoreRecord = true;
            values.clear();
        }
        return noMoreRecord ? null : values.toArray(new Object[values.size()]);
    }

    private void fillNull(List<?> values, int count) {
        for (int i = 0; i < count; ++i) {
            values.add(null);
        }
    }

    protected abstract int doNext() throws SpreadsheetException;
}

