/*
 * Decompiled with CFR 0.152.
 */
package com.github.nomou.spreadsheet;

import com.github.nomou.spreadsheet.SpreadsheetException;
import com.github.nomou.spreadsheet.SpreadsheetWriter;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;

public abstract class AbstractSpreadsheetWriter
implements SpreadsheetWriter {
    protected int row;
    protected int col;
    protected int unnamedCount = 1;

    @Override
    public SpreadsheetWriter start() throws SpreadsheetException {
        return this.start("sheet" + this.unnamedCount++);
    }

    @Override
    public <E> SpreadsheetWriter write(E ... cells) throws SpreadsheetException {
        return this.write((Object)cells);
    }

    @Override
    public SpreadsheetWriter write(Object obj) throws SpreadsheetException {
        if (null == obj) {
            this.write("");
            return this;
        }
        if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                this.write(Array.get(obj, i));
            }
            return this;
        }
        if (obj instanceof Boolean) {
            this.write((Boolean)obj);
        } else if (obj instanceof Number) {
            this.write((Number)obj);
        } else if (obj instanceof Date) {
            this.write((Date)obj);
        } else if (obj instanceof Calendar) {
            this.write(((Calendar)obj).getTime());
        } else {
            this.write(String.valueOf(obj));
        }
        return this;
    }

    @Override
    public AbstractSpreadsheetWriter next() throws SpreadsheetException {
        ++this.row;
        this.col = 0;
        return this;
    }
}

