/*
 * Decompiled with CFR 0.152.
 */
package com.github.nomou.spreadsheet;

import com.github.nomou.spreadsheet.SpreadsheetException;
import com.github.nomou.spreadsheet.SpreadsheetParser;
import com.github.nomou.spreadsheet.spi.SpreadsheetParserFactory;
import com.github.nomou.spreadsheet.spi.SpreadsheetWriterFactory;
import com.github.nomou.spreadsheet.util.SpreadsheetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public final class Spreadsheet {
    private static final List<Format> ALL_FORMATS = new LinkedList<Format>();
    private static final Map<byte[], List<SpreadsheetParserFactory>> PARSER_FACTORIES_MAP = Spreadsheet.loadSpreadsheetParserFactories();
    private static final Map<String, List<SpreadsheetWriterFactory>> WRITER_FACTORIES_MAP = Spreadsheet.loadSpreadsheetWriterFactories();

    public static SpreadsheetWriterFactory getWriterFactory(String extension) {
        List<SpreadsheetWriterFactory> factories = WRITER_FACTORIES_MAP.get(extension.toLowerCase());
        if (null == factories || factories.isEmpty()) {
            throw new IllegalStateException("No suite SpreadsheetWriterFactory found for " + extension);
        }
        return factories.iterator().next();
    }

    public static SpreadsheetParserFactory getParserFactory(String ... extensions) {
        Map<byte[], List<SpreadsheetParserFactory>> factoryMap;
        List<Format> formats;
        if (0 == extensions.length) {
            formats = Spreadsheet.getFormatsByHeaders(PARSER_FACTORIES_MAP.keySet());
            factoryMap = PARSER_FACTORIES_MAP;
        } else {
            HashMap<byte[], List<SpreadsheetParserFactory>> filtered = new HashMap<byte[], List<SpreadsheetParserFactory>>();
            formats = Spreadsheet.getFormatsByExtensions(extensions);
            for (Format format : formats) {
                filtered.put(format.header, PARSER_FACTORIES_MAP.get(format.header));
            }
            factoryMap = filtered;
        }
        if (factoryMap.isEmpty()) {
            throw new IllegalStateException("No suite SpreadsheetParserFactory found for " + Arrays.toString(extensions));
        }
        Format[] formatArray = new Format[formats.size()];
        return new MixedSpreadsheetParserFactory(formats.toArray(formatArray), factoryMap);
    }

    private static List<Format> getFormatsByExtensions(String ... extensions) {
        ArrayList<Format> formats = new ArrayList<Format>(extensions.length);
        for (Format format : ALL_FORMATS) {
            for (String ext : extensions) {
                if (!Arrays.asList(format.extensions).contains(ext)) continue;
                formats.add(format);
            }
        }
        return formats;
    }

    private static List<Format> getFormatsByHeaders(Collection<byte[]> headers) {
        ArrayList<Format> formats = new ArrayList<Format>(headers.size());
        for (byte[] header : headers) {
            Format format = Spreadsheet.getFormatByHeader(header);
            if (null == format) continue;
            formats.add(format);
        }
        return formats;
    }

    private static Format getFormatByHeader(byte[] header) {
        for (Format format : ALL_FORMATS) {
            if (!Arrays.equals(format.header, header)) continue;
            return format;
        }
        return null;
    }

    private static Map<byte[], List<SpreadsheetParserFactory>> loadSpreadsheetParserFactories() {
        HashMap<byte[], List<SpreadsheetParserFactory>> factoriesMap = new HashMap<byte[], List<SpreadsheetParserFactory>>();
        ServiceLoader<SpreadsheetParserFactory> loader = ServiceLoader.load(SpreadsheetParserFactory.class);
        for (SpreadsheetParserFactory factory : loader) {
            Format[] formats;
            for (Format format : formats = factory.getSupportedFormats()) {
                byte[] header;
                ArrayList<SpreadsheetParserFactory> factories;
                if (!ALL_FORMATS.contains(format)) {
                    ALL_FORMATS.add(format);
                }
                if (null == (factories = (ArrayList<SpreadsheetParserFactory>)factoriesMap.get(header = format.header))) {
                    factories = new ArrayList<SpreadsheetParserFactory>();
                    factoriesMap.put(header, factories);
                }
                factories.add(factory);
            }
        }
        return factoriesMap;
    }

    private static Map<String, List<SpreadsheetWriterFactory>> loadSpreadsheetWriterFactories() {
        HashMap<String, List<SpreadsheetWriterFactory>> factoriesMap = new HashMap<String, List<SpreadsheetWriterFactory>>(10);
        ServiceLoader<SpreadsheetWriterFactory> loader = ServiceLoader.load(SpreadsheetWriterFactory.class);
        for (SpreadsheetWriterFactory factory : loader) {
            Format[] formats;
            for (Format format : formats = factory.getSupportedFormats()) {
                if (!ALL_FORMATS.contains(format)) {
                    ALL_FORMATS.add(format);
                }
                for (String extension : format.extensions) {
                    ArrayList<SpreadsheetWriterFactory> factories = (ArrayList<SpreadsheetWriterFactory>)factoriesMap.get(extension.toLowerCase());
                    if (null == factories) {
                        factories = new ArrayList<SpreadsheetWriterFactory>();
                        factoriesMap.put(extension.toLowerCase(), factories);
                    }
                    factories.add(factory);
                }
            }
        }
        return factoriesMap;
    }

    private Spreadsheet() {
    }

    private static class MixedSpreadsheetParserFactory
    implements SpreadsheetParserFactory {
        private final Format[] formats;
        private final Map<byte[], List<SpreadsheetParserFactory>> factoriesMap;

        private MixedSpreadsheetParserFactory(Format[] formats, Map<byte[], List<SpreadsheetParserFactory>> factories) {
            this.formats = formats;
            this.factoriesMap = factories;
        }

        @Override
        public Format[] getSupportedFormats() {
            return this.formats;
        }

        @Override
        public SpreadsheetParser create(InputStream in) throws SpreadsheetException {
            try {
                List<SpreadsheetParserFactory> factories = SpreadsheetUtils.matches(in, this.factoriesMap);
                if (null != factories) {
                    if (factories.isEmpty()) {
                        throw new SpreadsheetException("file type error");
                    }
                    SpreadsheetException lastError = null;
                    for (SpreadsheetParserFactory factory : factories) {
                        try {
                            return factory.create(in);
                        }
                        catch (SpreadsheetException ex) {
                            lastError = ex;
                        }
                    }
                    throw lastError;
                }
                for (List<SpreadsheetParserFactory> tryFactories : this.factoriesMap.values()) {
                    for (SpreadsheetParserFactory tryFactory : tryFactories) {
                        try {
                            return tryFactory.create(in);
                        }
                        catch (SpreadsheetException ex) {
                            if (in.markSupported()) continue;
                            throw new SpreadsheetException("input must be available markSupported,you can do like this 'new BufferedInputStream(new FileInputStream(\"/xxxx\"))'");
                        }
                    }
                }
                throw new SpreadsheetException("not supported");
            }
            catch (IOException e) {
                throw new SpreadsheetException(e);
            }
        }
    }

    public static class Format {
        private final String name;
        private final byte[] header;
        private final String[] extensions;

        public Format(String name, byte[] header, String ... extensions) {
            this.name = name;
            this.header = header;
            this.extensions = extensions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Format format = (Format)o;
            if (!Arrays.equals(this.header, format.header)) {
                return false;
            }
            return Arrays.equals(this.extensions, format.extensions);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.header);
            result = 31 * result + Arrays.hashCode(this.extensions);
            return result;
        }

        public String toString() {
            return "Format {" + this.name + "(" + Arrays.toString(this.extensions) + ") }";
        }
    }
}

