/*
 * Decompiled with CFR 0.152.
 */
package com.github.nomou.spreadsheet.util;

import freework.util.Castor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class SpreadsheetRecord {
    private final List<?> data;

    public static SpreadsheetRecord wrap(Object[] data) {
        return SpreadsheetRecord.wrap(null != data ? Arrays.asList(data) : null);
    }

    public static SpreadsheetRecord wrap(List<?> data) {
        return new SpreadsheetRecord(data);
    }

    private SpreadsheetRecord(List<?> data) {
        this.data = data;
    }

    public boolean isNull() {
        return null == this.data;
    }

    public boolean isEmpty() {
        return null == this.data || this.data.isEmpty();
    }

    public int size() {
        return !this.isNull() ? this.data.size() : 0;
    }

    public Object getValue(int columnIndex) {
        return columnIndex < this.size() ? this.data.get(columnIndex) : null;
    }

    public Object getValue(String columnName) {
        return this.getValue(this.nameToIndex(columnName));
    }

    public Boolean getBoolean(int columnIndex) {
        return columnIndex < this.size() ? Castor.asBoolean(this.data.get(columnIndex)) : null;
    }

    public Boolean getBoolean(String columnName) {
        return this.getBoolean(this.nameToIndex(columnName));
    }

    public Number getNumber(int columnIndex) {
        return columnIndex < this.size() ? (Number)Castor.asNumber(this.data.get(columnIndex), Number.class) : (Number)null;
    }

    public Number getNumber(String columnName) {
        return this.getNumber(this.nameToIndex(columnName));
    }

    public String getString(int columnIndex) {
        return columnIndex < this.size() ? Castor.asString(this.data.get(columnIndex)) : null;
    }

    public String getString(String columnName) {
        return this.getString(this.nameToIndex(columnName));
    }

    public Date getDate(int columnIndex) {
        return columnIndex < this.size() ? Castor.asDate(this.data.get(columnIndex)) : null;
    }

    public Date getDate(String columnName) {
        return this.getDate(this.nameToIndex(columnName));
    }

    private int nameToIndex(String columnName) {
        int column = -1;
        for (int i = 0; i < columnName.length(); ++i) {
            char c = columnName.charAt(i);
            column = (column + 1) * 26 + c - 65;
        }
        return column;
    }
}

