/*
 * Decompiled with CFR 0.152.
 */
package com.github.nomou.spreadsheet.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SpreadsheetUtils {
    private static final Comparator<byte[]> LEN_FIRST_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return Long.compare(o2.length, o1.length);
        }
    };

    private SpreadsheetUtils() {
    }

    public static <T> List<T> matches(InputStream in, Map<byte[], List<T>> candidateMap) throws IOException {
        if (!in.markSupported()) {
            return null;
        }
        byte[] bytes = SpreadsheetUtils.peekFirstNBytes(in, 8);
        List<T> candidates = candidateMap.get(bytes);
        if (null != candidates) {
            return candidates;
        }
        LinkedList ret = new LinkedList();
        LinkedList any = new LinkedList();
        ArrayList<byte[]> keys = new ArrayList<byte[]>(candidateMap.keySet());
        Collections.sort(keys, LEN_FIRST_COMPARATOR);
        for (byte[] expect : keys) {
            if (null == expect || 0 >= expect.length) {
                any.addAll(candidateMap.get(expect));
                continue;
            }
            byte[] given = bytes.length > expect.length ? Arrays.copyOf(bytes, expect.length) : bytes;
            if (!Arrays.equals(given, expect)) continue;
            ret.addAll(candidateMap.get(expect));
        }
        ret.addAll(any);
        return ret;
    }

    public static byte[] peekFirstNBytes(InputStream in, int limit) throws IOException {
        in.mark(limit);
        byte[] bytes = new byte[limit];
        int len = in.read(bytes);
        if (len == 0) {
            throw new IllegalStateException("empty stream");
        }
        if (in instanceof PushbackInputStream) {
            ((PushbackInputStream)in).unread(bytes, 0, len);
        } else {
            in.reset();
        }
        return bytes;
    }
}

