/*
 * Decompiled with CFR 0.152.
 */
package solutions.nyla.apacheKafka;

import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import nyla.solutions.core.util.Config;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import solutions.nyla.apacheKafka.KafkaQueue;

public class ApacheKafka {
    private final String bootStrapServersConfig;
    private final String groupdId;

    private ApacheKafka(String bootStrapServersConfig, String groupdId) {
        if (bootStrapServersConfig == null || bootStrapServersConfig.length() == 0) {
            throw new IllegalArgumentException("bootStrapServersConfig is required");
        }
        this.bootStrapServersConfig = bootStrapServersConfig;
        this.groupdId = groupdId;
    }

    public static ApacheKafka connect() {
        return ApacheKafka.connect(Config.getProperty((String)"BOOTSTRAP_SERVERS_CONFIG"), Config.getProperty((String)"KAFKA_GROUP_ID"));
    }

    public static ApacheKafka connect(String bootStrapServersConfig, String groupId) {
        return new ApacheKafka(bootStrapServersConfig, groupId);
    }

    public <K, V> void push(String topic, K key, V value) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootStrapServersConfig);
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        try (KafkaProducer producer = new KafkaProducer(props);){
            producer.send(new ProducerRecord(topic, key, value));
        }
    }

    public <E> BlockingQueue<E> queue(String topic) {
        KafkaQueue q = new KafkaQueue(topic, this.bootStrapServersConfig, this.groupdId);
        new Thread(q).start();
        return q;
    }
}

