/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nyla.solutions.core.data.Criteria;
import nyla.solutions.core.data.Updateable;
import nyla.solutions.core.util.Debugger;

public abstract class Data
implements Serializable {
    private static final long serialVersionUID = -2411033885084918560L;
    public static final int NULL = -1;
    public static final String TRUE = "T";
    public static final String FALSE = "F";
    public static final String YES = "Y";
    public static final String NO = "N";

    public static boolean isNull(String text) {
        return text == null || text.trim().length() == 0 || "null".equals(text.trim());
    }

    public String toString() {
        return Debugger.toString(this);
    }

    public static <T> Collection<T> sortByCriteria(Collection<T> aVOs) {
        ArrayList<T> list = null;
        list = aVOs instanceof List ? (ArrayList<T>)aVOs : new ArrayList<T>(aVOs);
        Collections.sort(list, new CriteriaComparator());
        return list;
    }

    public static <T> Collection<T> sortByUpdateDate(Collection<T> collection) {
        ArrayList<T> list = null;
        list = collection instanceof List ? (ArrayList<T>)collection : new ArrayList<T>(collection);
        Collections.sort(list, new UpdateDateComparator());
        return list;
    }

    public static class UpdateDateComparator
    implements Comparator<Object>,
    Serializable {
        static final long serialVersionUID = UpdateDateComparator.class.getName().hashCode();

        @Override
        public int compare(Object first, Object second) {
            if (first == null) {
                return 1;
            }
            Updateable vo1 = (Updateable)first;
            Updateable vo2 = (Updateable)second;
            if (vo1.getUpdateDate() == null) {
                return -1;
            }
            return vo1.getUpdateDate().compareTo(vo2.getUpdateDate());
        }
    }

    public static class CriteriaComparator
    implements Comparator<Object>,
    Serializable {
        static final long serialVersionUID = CriteriaComparator.class.getName().hashCode();

        @Override
        public int compare(Object first, Object second) {
            if (first == null) {
                return 1;
            }
            Criteria vo1 = (Criteria)first;
            Criteria vo2 = (Criteria)second;
            return Integer.compare(vo1.getPrimaryKey(), vo2.getPrimaryKey());
        }
    }
}

