/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data;

import java.io.Serializable;
import nyla.solutions.core.data.Attribute;
import nyla.solutions.core.data.Copier;
import nyla.solutions.core.data.Mappable;
import nyla.solutions.core.util.Text;

public class Property
implements Serializable,
Mappable<Object, Object>,
Comparable<Object>,
Cloneable,
Copier,
Attribute<Object, Object> {
    private String name = "";
    private Serializable value = "";
    static final long serialVersionUID = Property.class.getName().hashCode();

    public Property() {
        this.name = null;
        this.value = null;
    }

    public Property(String aName, Serializable aValue) {
        this.setName(aName);
        this.setValue(aValue);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compareTo(Object other) {
        Property otherProperty = (Property)other;
        if (this.name == null) {
            return -1;
        }
        int compare = this.name.compareTo(otherProperty.getName());
        if (compare == 0) {
            Object value = this.getValue();
            if (!(value instanceof Comparable)) {
                return compare;
            }
            return ((Comparable)value).compareTo(otherProperty.getValue());
        }
        return compare;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name.trim();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Serializable value) {
        this.value = value;
    }

    @Override
    public Object getKey() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void copy(Copier aFrom) {
        if (!(aFrom instanceof Property)) {
            throw new IllegalArgumentException("aFrom instanceof aFrom required in Property.copy");
        }
        Property from = (Property)aFrom;
        this.name = from.name;
        this.value = from.value;
    }

    public String toString() {
        StringBuffer text = new StringBuffer("[").append(this.getClass().getName()).append("]").append(" name: ").append(this.name).append(" value: ").append(this.value);
        return text.toString();
    }

    @Override
    public boolean equalsValueIgnoreCase(Object aValue) {
        return String.valueOf(this.value).equalsIgnoreCase(String.valueOf(aValue));
    }

    public Integer getValueInteger() {
        String textValue = String.valueOf(this.value);
        if (Text.isInteger(textValue)) {
            return Integer.valueOf(textValue);
        }
        return null;
    }

    public void setKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key required in Property.setKey");
        }
        this.name = key.toString();
    }

    public void setTextValue(String text) {
        this.setValue((Serializable)((Object)text));
    }

    public String getTextValue() {
        return (String)this.getValue();
    }
}

