/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.clock;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.util.Text;

public class Day
implements Comparable<Day>,
Serializable {
    public static final String DAY_FORMAT = "MM/dd/yyyy";
    private static final long serialVersionUID = 7895096174662828704L;
    protected final Calendar calendar_;

    public Day(int year, int month, int dayOfMonth) {
        this();
        this.calendar_.set(1, year);
        this.calendar_.set(2, month);
        this.calendar_.set(5, dayOfMonth);
    }

    public Day(String date) {
        this(Text.toDate(date, DAY_FORMAT));
    }

    public Day(int year, int dayOfYear) {
        this();
        this.calendar_.set(1, year);
        this.calendar_.set(6, dayOfYear);
    }

    public Day() {
        this.calendar_ = Calendar.getInstance();
        this.init();
    }

    public Day(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("calendar cannot be null");
        }
        this.calendar_ = (Calendar)calendar.clone();
        this.init();
    }

    public Day(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("dat cannot be null");
        }
        this.calendar_ = Calendar.getInstance();
        this.calendar_.setTime(date);
        this.init();
    }

    public Day(long time) {
        this(new Date(time));
    }

    public Day(Day day) {
        if (day == null) {
            throw new IllegalArgumentException("day cannot be null");
        }
        this.calendar_ = (Calendar)day.calendar_.clone();
        this.init();
    }

    public void init() {
        this.calendar_.set(11, 0);
        this.calendar_.set(12, 0);
        this.calendar_.set(13, 0);
        this.calendar_.set(14, 0);
    }

    public static Day today() {
        return new Day();
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendar_.clone();
    }

    public Date getDate() {
        return this.calendar_.getTime();
    }

    @Override
    public int compareTo(Day object) {
        if (object == null) {
            throw new IllegalArgumentException("day cannot be null");
        }
        Day day = object;
        return this.calendar_.getTime().compareTo(day.calendar_.getTime());
    }

    public boolean isAfter(Day day) {
        if (day == null) {
            throw new IllegalArgumentException("day cannot be null");
        }
        return this.calendar_.after(day.calendar_);
    }

    public boolean isBefore(Day day) {
        if (day == null) {
            throw new IllegalArgumentException("day cannot be null");
        }
        return this.calendar_.before(day.calendar_);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Day)) {
            return false;
        }
        Day day = (Day)object;
        return this.calendar_.equals(day.calendar_);
    }

    public int hashCode() {
        return this.calendar_.hashCode();
    }

    public int getYear() {
        return this.calendar_.get(1);
    }

    public int getMonth() {
        return this.calendar_.get(2);
    }

    public int getMonthNo() {
        switch (this.getMonth()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 12;
            }
        }
        throw new SystemException("Invalid mongth: " + this.getMonth());
    }

    public int getDayOfMonth() {
        return this.calendar_.get(5);
    }

    public int getDayOfYear() {
        return this.calendar_.get(6);
    }

    public int getDayOfWeek() {
        return this.calendar_.get(7);
    }

    public int getDayNumberOfWeek() {
        return this.getDayOfWeek() == 1 ? 7 : this.getDayOfWeek() - 1;
    }

    public int getWeekOfYear() {
        return this.calendar_.get(3);
    }

    public Day addDays(int nDays) {
        Calendar calendar = (Calendar)this.calendar_.clone();
        calendar.add(5, nDays);
        return new Day(calendar);
    }

    public Day subtractDays(int nDays) {
        return this.addDays(-nDays);
    }

    public Day addMonths(int nMonths) {
        Calendar calendar = (Calendar)this.calendar_.clone();
        calendar.add(2, nMonths);
        return new Day(calendar);
    }

    public Day subtractMonths(int nMonths) {
        return this.addMonths(-nMonths);
    }

    public Day addYears(int nYears) {
        Calendar calendar = (Calendar)this.calendar_.clone();
        calendar.add(1, nYears);
        return new Day(calendar);
    }

    public Day subtractYears(int nYears) {
        return this.addYears(-nYears);
    }

    public int getDaysInYear() {
        return this.calendar_.getActualMaximum(6);
    }

    public boolean isLeapYear() {
        return this.getDaysInYear() == this.calendar_.getMaximum(6);
    }

    public static boolean isLeapYear(int year) {
        return new Day(year, 0, 1).isLeapYear();
    }

    public int getDaysInMonth() {
        return this.calendar_.getActualMaximum(5);
    }

    public String getDayName() {
        switch (this.getDayOfWeek()) {
            case 2: {
                return "Monday";
            }
            case 3: {
                return "Tuesday";
            }
            case 4: {
                return "Wednesday";
            }
            case 5: {
                return "Thursday";
            }
            case 6: {
                return "Friday";
            }
            case 7: {
                return "Saturday";
            }
            case 1: {
                return "Sunday";
            }
        }
        throw new SystemException("Invalid day of week: " + this.getDayOfWeek());
    }

    public int daysBetween(Day day) {
        if (day == null) {
            throw new IllegalArgumentException("day cannot be null");
        }
        long millisBetween = Math.abs(this.calendar_.getTime().getTime() - day.calendar_.getTime().getTime());
        Double results = (double)millisBetween / 8.64E7;
        return results.intValue();
    }

    public static Day getNthOfMonth(int n, int dayOfWeek, int month, int year) {
        int dayNo;
        if (dayOfWeek < 0 || dayOfWeek > 6) {
            throw new IllegalArgumentException("Invalid day of week: " + dayOfWeek);
        }
        Day first = new Day(year, month, 1);
        int offset = dayOfWeek - first.getDayOfWeek();
        if (offset < 0) {
            offset = 7 + offset;
        }
        return (dayNo = (n - 1) * 7 + offset + 1) > first.getDaysInMonth() ? null : new Day(year, month, dayNo);
    }

    public static Day getFirstOfMonth(int dayOfWeek, int month, int year) {
        return Day.getNthOfMonth(1, dayOfWeek, month, year);
    }

    public static Day getLastOfMonth(int dayOfWeek, int month, int year) {
        Day day = Day.getNthOfMonth(5, dayOfWeek, month, year);
        return day != null ? day : Day.getNthOfMonth(4, dayOfWeek, month, year);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.getMonth() < 9) {
            s.append('0');
        }
        s.append(this.getMonth() + 1);
        s.append('/');
        if (this.getDayOfMonth() < 10) {
            s.append('0');
        }
        s.append(this.getDayOfMonth());
        s.append('/');
        s.append(this.getYear());
        s.append(" ");
        s.append(this.getDayName());
        return s.toString();
    }

    public static void main(String[] arguments) {
        Day september11 = new Day(2001, 8, 11);
        Day march11 = new Day(2004, 2, 11);
        System.out.println(september11.daysBetween(march11));
        Day precidency = new Day(1961, 0, 20);
        Day assasination = new Day(1963, 10, 22);
        System.out.println(precidency.daysBetween(assasination) + 1);
        Day nielOnMoon = new Day(1969, 6, 20);
        System.out.println(nielOnMoon.getDayName());
        for (int i = 0; i < 12; ++i) {
            Day tuesday = Day.getLastOfMonth(3, i, 2005);
            System.out.println(tuesday);
        }
    }

    public boolean isSameDay(Day compared) {
        if (compared == null) {
            return false;
        }
        return this.getMonth() == compared.getMonth() && this.getDayOfMonth() == compared.getDayOfMonth() && this.getYear() == compared.getYear();
    }

    protected void initialize(int year, int month, int dayOfMonth) {
        this.calendar_.set(1, year);
        this.calendar_.set(2, month);
        this.calendar_.set(5, dayOfMonth);
    }
}

