/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.clock;

import java.util.Calendar;
import java.util.Date;
import nyla.solutions.core.data.clock.Day;

public class Time
extends Day {
    private static final long serialVersionUID = -7760994938523990073L;

    public Time(int year, int month, int dayOfMonth, int hours, int minutes, int seconds) {
        super(year, month, dayOfMonth);
        this.setHour24(hours);
        this.setMinutes(minutes);
        this.setSeconds(seconds);
    }

    public Time(Date date) {
        this.assignDate(date);
    }

    public void assignDate(Date date) {
        if (date == null) {
            return;
        }
        this.setDay(new Day(date));
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.setHour24(cal.get(11));
        this.setMinutes(cal.get(12));
        this.setSeconds(cal.get(13));
    }

    public Time(Day day, int hours, int minutes, int seconds) {
        this(day.getYear(), day.getMonth(), day.getDayOfMonth(), hours, minutes, seconds);
    }

    public Time(int hours, int minutes, int seconds) {
        this(new Day(), hours, minutes, seconds);
    }

    public Time() {
    }

    public void setDay(Day day) {
        super.initialize(day.getYear(), day.getMonth(), day.getDayOfMonth());
    }

    public void setHour24(int hours) {
        this.calendar_.set(11, hours);
    }

    public int getHour24() {
        return this.calendar_.get(11);
    }

    public int getHour() {
        return this.calendar_.get(10);
    }

    public String getAmOrPm() {
        if (0 == this.calendar_.get(9)) {
            return "AM";
        }
        return "PM";
    }

    public void setMinutes(int minutes) {
        this.calendar_.set(12, minutes);
    }

    public int getMinutes() {
        return this.calendar_.get(12);
    }

    public void setSeconds(int seconds) {
        this.calendar_.set(13, seconds);
    }

    public int getSeconds() {
        return this.calendar_.get(13);
    }

    public void setMilliSeconds(int milliSeconds) {
        this.calendar_.set(14, milliSeconds);
    }

    public int getMilliSeconds() {
        return this.calendar_.get(14);
    }

    public boolean isAfter(Time time) {
        return this.calendar_.after(time.calendar_);
    }

    public boolean isBefore(Time time) {
        return this.calendar_.before(time.calendar_);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Time time = (Time)obj;
        return this.calendar_.equals(time.calendar_);
    }

    public void addHours(int nHours) {
        this.calendar_.add(11, nHours);
    }

    public void addMinutes(int nMinutes) {
        this.calendar_.add(12, nMinutes);
    }

    public void addSeconds(int nSeconds) {
        this.calendar_.add(13, nSeconds);
    }

    public void addMilliSeconds(int nMilliSeconds) {
        this.calendar_.add(14, nMilliSeconds);
    }

    public long milliSecondsBetween(Time time) {
        long millisBetween = this.calendar_.getTime().getTime() - time.calendar_.getTime().getTime();
        return millisBetween;
    }

    public double secondsBetween(Time time) {
        long millisBetween = this.calendar_.getTime().getTime() - time.calendar_.getTime().getTime();
        return (double)millisBetween / 1000.0;
    }

    public double minutesBetween(Time time) {
        long millisBetween = this.calendar_.getTime().getTime() - time.calendar_.getTime().getTime();
        return (double)millisBetween / 60000.0;
    }

    public double hoursBetween(Time time) {
        long millisBetween = this.calendar_.getTime().getTime() - time.calendar_.getTime().getTime();
        return (double)millisBetween / 3600000.0;
    }

    @Override
    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append(super.toString());
        string.append(' ');
        if (this.getHour24() < 10) {
            string.append('0');
        }
        string.append(this.getHour24());
        string.append(':');
        if (this.getMinutes() < 10) {
            string.append('0');
        }
        string.append(this.getMinutes());
        string.append(':');
        if (this.getSeconds() < 10) {
            string.append('0');
        }
        string.append(this.getSeconds());
        string.append(',');
        string.append(this.getMilliSeconds());
        return string.toString();
    }

    public static void main(String[] args) {
        Time time = new Time(12, 0, 0);
        System.out.println(time);
    }
}

