/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.clock;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import nyla.solutions.core.data.clock.Day;
import nyla.solutions.core.data.clock.Time;
import nyla.solutions.core.data.clock.TimeInterval;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.util.Scheduler;

public class TimeSlot
implements Serializable,
Comparable<Object>,
TimeInterval {
    private static final long serialVersionUID = -6155840093186057564L;
    private Date start = null;
    private Date end = null;

    public TimeSlot() {
    }

    public TimeSlot(Date start, Date end) {
        this.setStartDate(start);
        this.setEndDate(end);
    }

    public double getDurationhours() {
        this.check();
        return Scheduler.durationHours(this.start, this.end);
    }

    public TimeSlot nextTimeSlot(int intervalSeconds, Time cutOffTime) {
        Date newStart = (Date)this.end.clone();
        Calendar newEnd = Calendar.getInstance();
        newEnd.setTime(newStart);
        newEnd.add(13, intervalSeconds);
        Date newEndDate = newEnd.getTime();
        TimeSlot newTimeSlot = new TimeSlot(newStart, newEndDate);
        if (cutOffTime == null || cutOffTime.getDate() == null) {
            return newTimeSlot;
        }
        if (newEndDate.after(cutOffTime.getDate())) {
            return null;
        }
        if (newTimeSlot.getEndDate().after(cutOffTime.getDate())) {
            return null;
        }
        return newTimeSlot;
    }

    public double getDurationMinutes() {
        this.check();
        return Scheduler.durationMinutes(this.start, this.end);
    }

    public double getDurationSeconds() {
        this.check();
        return Scheduler.durationSeconds(this.start, this.end);
    }

    private void check() {
        if (this.start == null) {
            return;
        }
        if (this.end == null) {
            return;
        }
        if (this.start.after(this.end)) {
            throw new IllegalStateException("Start " + this.start + "must be before end " + this.end);
        }
    }

    @Override
    public Date getStartDate() {
        if (this.start == null) {
            return null;
        }
        return new Date(this.start.getTime());
    }

    @Override
    public void setStartDate(Date start) {
        this.start = start == null ? null : new Date(start.getTime());
        this.check();
    }

    @Override
    public Date getEndDate() {
        if (this.end == null) {
            return null;
        }
        return (Date)this.end.clone();
    }

    public Time getEndTime() {
        return new Time(this.end);
    }

    public Time getStartTime() {
        return new Time(this.start);
    }

    @Override
    public void setEndDate(Date end) {
        this.end = end == null ? null : new Date(end.getTime());
        this.check();
    }

    public static TimeSlot firstSlot(Day day, Time start, int intervalSeconds) {
        if (day == null) {
            throw new RequiredException("date in TimeSlot.firstSlot");
        }
        Date startDate = Scheduler.toDate(day, start);
        Calendar end = Calendar.getInstance();
        end.setTime(startDate);
        end.add(13, intervalSeconds);
        return new TimeSlot(startDate, end.getTime());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSlot other = (TimeSlot)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    @Override
    public int compareTo(Object object) {
        TimeSlot other = (TimeSlot)object;
        if (this.equals(other)) {
            return 0;
        }
        if (this.start.before(other.start)) {
            return -1;
        }
        return 1;
    }
}

