/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.conversation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import nyla.solutions.core.data.conversation.BaggedObject;
import nyla.solutions.core.data.conversation.DateBag;

public class ArrayListBag
implements Serializable,
BaggedObject<ArrayList<Object>> {
    private static final long serialVersionUID = 4995496063381565327L;
    private Object[] arrayObj;

    public ArrayListBag() {
    }

    public ArrayListBag(ArrayList<Object> list) {
        this.bag(list);
    }

    @Override
    public void bag(ArrayList<Object> unBaggedObject) {
        if (unBaggedObject == null || unBaggedObject.isEmpty()) {
            return;
        }
        this.arrayObj = new Object[unBaggedObject.size()];
        Object obj = null;
        for (int i = 0; i < this.arrayObj.length; ++i) {
            obj = unBaggedObject.get(i);
            if (obj instanceof Date) {
                obj = new DateBag((Date)obj);
            } else if (obj instanceof ArrayList) {
                obj = new ArrayListBag((ArrayList)obj);
            }
            this.arrayObj[i] = obj;
        }
    }

    public Object[] getArrayObj() {
        if (this.arrayObj == null) {
            return null;
        }
        Object[] copy = new Object[this.arrayObj.length];
        System.arraycopy(this.arrayObj, 0, copy, 0, copy.length);
        return copy;
    }

    public void setArrayObj(Object[] arrayObj) {
        if (arrayObj == null) {
            return;
        }
        this.arrayObj = new Object[arrayObj.length];
        System.arraycopy(arrayObj, 0, this.arrayObj, 0, this.arrayObj.length);
    }

    @Override
    public ArrayList<Object> unbag() {
        if (this.arrayObj == null || this.arrayObj.length == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(this.arrayObj.length);
        Object value = null;
        for (int i = 0; i < this.arrayObj.length; ++i) {
            value = this.arrayObj[i];
            if (value instanceof BaggedObject) {
                value = ((BaggedObject)value).unbag();
            }
            list.add(value);
        }
        return list;
    }
}

