/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.ds;

import java.io.Closeable;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import nyla.solutions.core.ds.JXCallbackHandler;
import nyla.solutions.core.ds.JndiAction;
import nyla.solutions.core.ds.JndiSocketFactory;
import nyla.solutions.core.ds.security.LdapSecurityGroup;
import nyla.solutions.core.ds.security.LdapSecurityUser;
import nyla.solutions.core.exception.NoDataFoundException;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;

public class LDAP
implements Closeable {
    private static final String JAVA_NAMING_PROVIDER_URL = "java.naming.provider.url";
    public static final String SERVER_URL_PROP = "LDAP_SERVER_URL";
    public static final String TIMEOUT_SECS_PROP = "LDAP_TIMEOUT_SECS";
    public static final String ROOT_DN_PROP = "LDAP_ROOT_DN";
    public static final String UID_ATTRIB_NM_PROP = "LDAP_UID_ATTRIB_NM";
    public static final String GROUP_ATTRIB_NM_PROP = "LDAP_GROUP_ATTRIB_NM";
    public static final String MEMBEROF_ATTRIB_NM_PROP = "LDAP_MEMBEROF_ATTRIB_NM";
    public static final String DEFAULT_uidAttributeName = Config.getProperty("LDAP_UID_ATTRIB_NM", "uid");
    private SearchControls existanceConstraints;
    private final DirContext ctx;
    private final String url;
    private static Properties nameParserSyntax = null;

    public LDAP(DirContext c, String url) {
        this.existanceConstraints = new SearchControls();
        this.existanceConstraints.setSearchScope(0);
        this.existanceConstraints.setCountLimit(0L);
        this.existanceConstraints.setTimeLimit(0);
        this.existanceConstraints.setReturningAttributes(new String[]{"1.1"});
        this.ctx = c;
        this.url = url;
    }

    protected DirContext setupKerberosContext(Hashtable<String, Object> env) throws NamingException {
        LoginContext lc = null;
        try {
            lc = new LoginContext(this.getClass().getName(), new JXCallbackHandler());
            lc.login();
        }
        catch (LoginException ex) {
            throw new NamingException("login problem: " + ex);
        }
        DirContext ctx = (DirContext)Subject.doAs(lc.getSubject(), new JndiAction(env));
        if (ctx == null) {
            throw new NamingException("another problem with GSSAPI");
        }
        return ctx;
    }

    public LDAP(String url) throws NamingException {
        if (url == null) {
            throw new IllegalArgumentException("url is required");
        }
        this.url = url;
        this.existanceConstraints = new SearchControls();
        this.existanceConstraints.setSearchScope(0);
        this.existanceConstraints.setCountLimit(0L);
        this.existanceConstraints.setTimeLimit(0);
        this.existanceConstraints.setReturningAttributes(new String[]{"1.1"});
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        LDAP.setupBasicProperties(env, url);
        this.ctx = LDAP.openContext(env);
    }

    public LDAP(String url, String userDN, char[] pwd) throws NamingException {
        this.existanceConstraints = new SearchControls();
        this.existanceConstraints.setSearchScope(0);
        this.existanceConstraints.setCountLimit(0L);
        this.existanceConstraints.setTimeLimit(0);
        this.existanceConstraints.setReturningAttributes(new String[]{"1.1"});
        this.url = url;
        this.ctx = this.authenticateByDnForContext(userDN, pwd);
    }

    public DirContext authenticateByDnForContext(String userDN, char[] pwd) throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        LDAP.setupBasicProperties(env, this.url, false);
        LDAP.setupSimpleSecurityProperties(env, userDN, pwd);
        return LDAP.openContext(env);
    }

    public Principal authenicate(String uid, char[] password) throws SecurityException {
        String rootDN = Config.getProperty(ROOT_DN_PROP);
        int timeout = Config.getPropertyInteger(TIMEOUT_SECS_PROP);
        Debugger.println(LDAP.class, "timeout=" + timeout);
        String uidAttributeName = Config.getProperty(UID_ATTRIB_NM_PROP);
        String groupAttributeName = Config.getProperty(GROUP_ATTRIB_NM_PROP, "");
        String memberOfAttributeName = Config.getProperty(MEMBEROF_ATTRIB_NM_PROP, "");
        return this.authenicate(uid, password, rootDN, uidAttributeName, memberOfAttributeName, groupAttributeName, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenicate(String uid, char[] password, String rootDN, String uidAttributeName, String memberOfAttributeName, String groupNameAttributeName, int timeout) throws SecurityException {
        LdapSecurityUser ldapSecurityUser;
        block10: {
            if (uidAttributeName == null || uidAttributeName.length() == 0) {
                uidAttributeName = DEFAULT_uidAttributeName;
            }
            String uidSearch = "(" + uidAttributeName + "=" + uid + ")";
            NamingEnumeration<?> results = this.searchSubTree(rootDN, uidSearch, 1, timeout, null);
            SearchResult searchResult = LDAP.toSearchResult(results);
            String userDN = searchResult.getName() + ", " + rootDN;
            DirContext ctx = null;
            try {
                NamingEnumeration<?> groupsEnumeration;
                Attribute attribute;
                Attributes attributes;
                ctx = this.authenticateByDnForContext(userDN, password);
                LdapSecurityUser securityUser = new LdapSecurityUser(uid, userDN);
                Object groupEnumValue = null;
                if (memberOfAttributeName != null && memberOfAttributeName.length() > 0 && (attributes = ctx.getAttributes(userDN)) != null && (attribute = attributes.get(memberOfAttributeName)) != null && (groupsEnumeration = attribute.getAll()) != null) {
                    while (groupsEnumeration.hasMore()) {
                        groupEnumValue = groupsEnumeration.next();
                        if (groupEnumValue == null) continue;
                        securityUser.addGroup(new LdapSecurityGroup(groupEnumValue.toString(), groupNameAttributeName));
                    }
                }
                ldapSecurityUser = securityUser;
                if (ctx == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        ctx.close();
                    }
                    throw throwable;
                }
                catch (NamingException e) {
                    throw new SecurityException(e.getMessage(), e);
                }
                catch (NoDataFoundException e) {
                    throw new SecurityException(uidAttributeName + ":\"" + uid + "\" not found");
                }
            }
            ctx.close();
        }
        return ldapSecurityUser;
    }

    public static void setupBasicProperties(Hashtable<String, Object> env, String url) throws NamingException {
        LDAP.setupBasicProperties(env, url, false);
    }

    public static void setupBasicProperties(Hashtable<String, Object> env, String url, boolean tracing) throws NamingException {
        if (url == null) {
            throw new NamingException("URL not specified in openContext()!");
        }
        if (tracing) {
            env.put("com.sun.jndi.ldap.trace.ber", System.err);
        }
        env.put("java.naming.ldap.version", "3");
        if (env.get("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        env.put("java.naming.ldap.deleteRDN", "false");
        env.put("java.naming.referral", "follow");
        env.put("java.naming.ldap.attributes.binary", "photo jpegphoto jpegPhoto");
        env.put("java.naming.ldap.derefAliases", "finding");
        env.put("java.naming.security.authentication", "none");
        env.put(JAVA_NAMING_PROVIDER_URL, url);
    }

    public static void setupSimpleSecurityProperties(Hashtable<String, Object> env, String userDN, char[] pwd) {
        if (pwd == null) {
            pwd = new char[]{};
        }
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", new String(pwd));
    }

    public static void setupSSLProperties(Hashtable<String, Object> env, String cacerts, String clientcerts, char[] caKeystorePwd, char[] clientKeystorePwd, String caKeystoreType, String clientKeystoreType, boolean tracing, boolean sslTracing, String sslSocketFactory) throws NamingException {
        try {
            LDAP.setupSSLProperties(env, cacerts, clientcerts, caKeystorePwd, clientKeystorePwd, caKeystoreType, clientKeystoreType, sslTracing, sslSocketFactory);
        }
        catch (NamingException e) {
            Debugger.printError(e);
            throw e;
        }
        catch (Exception e) {
            throw new NamingException(Debugger.stackTrace(e));
        }
    }

    public static void setupSSLProperties(Hashtable<String, Object> env, String cacerts, String clientcerts, char[] caKeystorePwd, char[] clientKeystorePwd, String caKeystoreType, String clientKeystoreType, boolean sslTracing, String sslSocketFactory) throws NamingException, Exception {
        if (cacerts == null) {
            throw new NamingException("Cannot use SSL without a trusted CA certificates JKS file.");
        }
        env.put("java.naming.security.protocol", "ssl");
        if (sslSocketFactory.equals("com.ca.commons.jndi.JndiSocketFactory")) {
            JndiSocketFactory.init(cacerts, clientcerts, caKeystorePwd, clientKeystorePwd, caKeystoreType, clientKeystoreType);
        }
        env.put("java.naming.ldap.factory.socket", sslSocketFactory);
        if (clientcerts != null && clientKeystorePwd != null && clientKeystorePwd.length > 0) {
            env.put("java.naming.security.authentication", "EXTERNAL");
        }
        if (sslTracing) {
            System.setProperty("javax.net.debug", "ssl handshake verbose");
        }
    }

    public static DirContext openContext(Hashtable<?, ?> env) throws NamingException {
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    public void renameEntry(Name oldDN, Name newDN) throws NamingException {
        Name rdn = newDN.getSuffix(newDN.size() - 1);
        Name oldRdn = oldDN.getSuffix(oldDN.size() - 1);
        if (!oldRdn.toString().equals(rdn.toString())) {
            this.ctx.rename(oldDN, rdn);
        }
    }

    public void copyEntry(Name fromDN, Name toDN) throws NamingException {
        this.addEntry(toDN, this.read(fromDN));
    }

    public void addEntry(Name dn, Attributes atts) throws NamingException {
        this.ctx.createSubcontext(dn, atts);
    }

    public void deleteEntry(Name dn) throws NamingException {
        this.ctx.destroySubcontext(dn);
    }

    public boolean exists(Name nodeDN) throws NamingException {
        try {
            this.ctx.search(nodeDN, "(objectclass=*)", this.existanceConstraints);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
        catch (NullPointerException e) {
            if (this.ctx != null && this.ctx.getEnvironment().get("java.naming.factory.initial").toString().indexOf("dsml") > 0) {
                return false;
            }
            throw e;
        }
    }

    public boolean exists(String nodeDN) throws NamingException {
        try {
            this.ctx.search(nodeDN, "(objectclass=*)", this.existanceConstraints);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
        catch (NullPointerException e) {
            if (this.ctx != null && this.ctx.getEnvironment().get("java.naming.factory.initial").toString().indexOf("dsml") > 0) {
                return false;
            }
            throw e;
        }
    }

    public synchronized Attributes read(Name dn) throws NamingException {
        return this.read(dn, null);
    }

    public synchronized Attributes read(Name dn, String[] returnAttributes) throws NamingException {
        return this.ctx.getAttributes(dn, returnAttributes);
    }

    public void modifyAttributes(Name dn, int mod_type, Attributes attr) throws NamingException {
        this.ctx.modifyAttributes(dn, mod_type, attr);
    }

    public void modifyAttributes(Name dn, ModificationItem[] modList) throws NamingException {
        this.ctx.modifyAttributes(dn, modList);
    }

    public void updateEntry(Name dn, Attributes atts) throws NamingException {
        this.modifyAttributes(dn, 2, atts);
    }

    public void deleteAttribute(Name dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 3, (Attributes)atts);
    }

    public void deleteAttributes(Name dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 3, a);
    }

    public void updateAttribute(Name dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 2, (Attributes)atts);
    }

    public void updateAttributes(Name dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 2, a);
    }

    public void addAttribute(Name dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 1, (Attributes)atts);
    }

    public void addAttributes(Name dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 1, a);
    }

    public NamingEnumeration<?> list(Name Searchbase) throws NamingException {
        return this.rawSearchOneLevel(Searchbase, "(objectclass=*)", 0, 0, new String[]{"1.1"});
    }

    public NamingEnumeration<?> searchOneLevel(String searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.searchOneLevel(searchbase, filter, limit, timeout, new String[]{"1.1"});
    }

    public NamingEnumeration<?> searchOneLevel(String searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchOneLevel(new CompositeName(searchbase), filter, limit, timeout, returnAttributes);
    }

    public NamingEnumeration<?> searchOneLevel(Name searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.rawSearchOneLevel(searchbase, filter, limit, timeout, new String[]{"1.1"});
    }

    public NamingEnumeration<?> searchOneLevel(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchOneLevel(searchbase, filter, limit, timeout, returnAttributes);
    }

    protected NamingEnumeration<?> rawSearchOneLevel(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        constraints.setCountLimit(limit);
        constraints.setTimeLimit(timeout);
        constraints.setReturningAttributes(returnAttributes);
        NamingEnumeration<SearchResult> results = this.ctx.search(searchbase, filter, constraints);
        return results;
    }

    public NamingEnumeration<?> searchSubTree(Name searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.searchSubTree(searchbase, filter, limit, timeout, new String[]{"1.1"});
    }

    public NamingEnumeration<?> searchSubTree(String searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.searchSubTree(new CompositeName(searchbase), filter, limit, timeout, new String[]{"1.1"});
    }

    public NamingEnumeration<?> searchSubTree(String searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchSubTree(new CompositeName(searchbase), filter, limit, timeout, returnAttributes);
    }

    public NamingEnumeration<?> searchSubTree(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchSubTree(searchbase, filter, limit, timeout, returnAttributes);
    }

    protected NamingEnumeration<?> rawSearchSubTree(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        if (returnAttributes != null && returnAttributes.length == 0) {
            returnAttributes = new String[]{"objectClass"};
        }
        SearchControls constraints1 = new SearchControls();
        constraints1.setSearchScope(2);
        constraints1.setCountLimit(limit);
        constraints1.setTimeLimit(timeout);
        constraints1.setReturningAttributes(returnAttributes);
        SearchControls constraints = constraints1;
        return this.ctx.search(searchbase, filter, constraints);
    }

    public NamingEnumeration<?> searchBaseEntry(Name searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.rawSearchBaseEntry(searchbase, filter, limit, timeout, new String[]{"objectClass"});
    }

    public NamingEnumeration<?> searchBaseEntry(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchBaseEntry(searchbase, filter, limit, timeout, returnAttributes);
    }

    public static SearchResult toSearchResult(NamingEnumeration<?> aNamingEnumeration) throws NoDataFoundException {
        if (aNamingEnumeration == null || !aNamingEnumeration.hasMoreElements()) {
            throw new NoDataFoundException("no results " + aNamingEnumeration);
        }
        return (SearchResult)aNamingEnumeration.nextElement();
    }

    public static String toString(NamingEnumeration<?> aEnum) {
        if (aEnum == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        SearchResult element = null;
        while (aEnum.hasMoreElements()) {
            element = (SearchResult)aEnum.nextElement();
            sb.append(" name=").append(element.getName()).append(" attributes=").append(LDAP.toString(element.getAttributes())).append("\n");
        }
        return sb.toString();
    }

    public static String toString(Attributes aAttributes) {
        if (aAttributes == null || aAttributes.getAll() == null) {
            return "";
        }
        Attribute element = null;
        NamingEnumeration<? extends Attribute> nenum = aAttributes.getAll();
        StringBuffer text = new StringBuffer();
        while (nenum.hasMoreElements()) {
            try {
                element = nenum.next();
                text.append(" {").append(LDAP.toString(element)).append("} ");
            }
            catch (NamingException namingException) {}
        }
        return text.toString();
    }

    public static String toString(Attribute aAttribute) {
        if (aAttribute == null) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        text.append(" id=").append(aAttribute.getID()).append(">");
        for (int i = 0; i < aAttribute.size(); ++i) {
            try {
                text.append(" ").append(Debugger.toString(aAttribute.get(i)));
                continue;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return text.toString();
    }

    protected NamingEnumeration<?> rawSearchBaseEntry(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        NamingEnumeration<SearchResult> result = null;
        if (returnAttributes != null && returnAttributes.length == 0) {
            returnAttributes = new String[]{"objectClass"};
        }
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(0);
        constraints.setCountLimit(limit);
        constraints.setTimeLimit(timeout);
        constraints.setReturningAttributes(returnAttributes);
        result = this.ctx.search(searchbase, filter, constraints);
        return result;
    }

    public NamingEnumeration<?> searchBaseEntry(String searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.rawSearchBaseEntry(new CompositeName(searchbase), filter, limit, timeout, new String[]{"objectClass"});
    }

    public NamingEnumeration<?> searchBaseEntry(String searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.rawSearchBaseEntry(new CompositeName(searchbase), filter, limit, timeout, returnAttributes);
    }

    public void renameEntry(Name OldDN, Name NewDN, boolean deleteOldRDN) throws NamingException {
        String value = deleteOldRDN ? "true" : "false";
        try {
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", value);
            this.renameEntry(OldDN, NewDN);
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        }
        catch (NamingException e) {
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
            throw e;
        }
    }

    public void renameEntry(String oldDN, String newDN) throws NamingException {
        this.ctx.rename(oldDN, newDN);
    }

    public void copyEntry(String fromDN, String toDN) throws NamingException {
        this.addEntry(toDN, this.read(fromDN));
    }

    public void addEntry(String dn, Attributes atts) throws NamingException {
        this.ctx.createSubcontext(dn, atts);
    }

    public void deleteEntry(String dn) throws NamingException {
        this.ctx.destroySubcontext(dn);
    }

    public synchronized Attributes read(String dn) throws NamingException {
        return this.read(dn, null);
    }

    public synchronized Attributes read(String dn, String[] returnAttributes) throws NamingException {
        return this.ctx.getAttributes(dn, returnAttributes);
    }

    public void modifyAttributes(String dn, int mod_type, Attributes attr) throws NamingException {
        this.ctx.modifyAttributes(dn, mod_type, attr);
    }

    public void modifyAttributes(String dn, ModificationItem[] modList) throws NamingException {
        this.ctx.modifyAttributes(dn, modList);
    }

    public void updateEntry(String dn, Attributes atts) throws NamingException {
        this.modifyAttributes(dn, 2, atts);
    }

    public void deleteAttribute(String dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 3, (Attributes)atts);
    }

    public void deleteAttributes(String dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 3, a);
    }

    public void updateAttribute(String dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 2, (Attributes)atts);
    }

    public void updateAttributes(String dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 2, a);
    }

    public void addAttribute(String dn, Attribute a) throws NamingException {
        BasicAttributes atts = new BasicAttributes();
        atts.put(a);
        this.modifyAttributes(dn, 1, (Attributes)atts);
    }

    public void addAttributes(String dn, Attributes a) throws NamingException {
        this.modifyAttributes(dn, 1, a);
    }

    public NamingEnumeration<?> list(String Searchbase) throws NamingException {
        return this.rawSearchOneLevel(new CompositeName(Searchbase), "(objectclass=*)", 0, 0, new String[]{"1.1"});
    }

    @Override
    public void close() {
        try {
            if (this.ctx == null) {
                return;
            }
            this.ctx.close();
            return;
        }
        catch (NamingException e) {
            Debugger.printWarn(e);
            return;
        }
    }

    public void renameEntry(String OldDN, String NewDN, boolean deleteOldRDN) throws NamingException {
        String value = deleteOldRDN ? "true" : "false";
        try {
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", value);
            this.renameEntry(OldDN, NewDN);
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
        }
        catch (NamingException e) {
            this.ctx.addToEnvironment("java.naming.ldap.deleteRDN", "false");
            throw e;
        }
    }

    private static void setupLDAPSyntax() {
        nameParserSyntax = new Properties();
        nameParserSyntax.put("jndi.syntax.direction", "right_to_left");
        nameParserSyntax.put("jndi.syntax.separator", ",");
        nameParserSyntax.put("jndi.syntax.escape", "\\");
        nameParserSyntax.put("jndi.syntax.trimblanks", "true");
        nameParserSyntax.put("jndi.syntax.separator.typeval", "=");
    }

    public static Name getNameFromString(String iDN) throws NamingException {
        String DN = iDN;
        CompositeName CompositeFormDN = null;
        CompoundName CompoundFormDN = null;
        if (iDN.indexOf("ldap://") != -1 && (CompositeFormDN = new CompositeName(iDN)).size() != 0) {
            DN = CompositeFormDN.get(CompositeFormDN.size() - 1);
        }
        if (nameParserSyntax == null) {
            LDAP.setupLDAPSyntax();
        }
        CompoundFormDN = new CompoundName(DN, nameParserSyntax);
        return CompoundFormDN;
    }

    public static Name getNameFromSearchResult(SearchResult iDirectoryEntry, Name iBaseDN) throws InvalidNameException, NamingException {
        String RDN = LDAP.applyJNDIRDNBugWorkAround(iDirectoryEntry.getName());
        Name JNDIRDN = LDAP.getNameFromString(RDN);
        if (iDirectoryEntry.isRelative()) {
            JNDIRDN.addAll(0, iBaseDN);
        } else {
            JNDIRDN = (Name)iBaseDN.clone();
        }
        return JNDIRDN;
    }

    private static String applyJNDIRDNBugWorkAround(String iRDN) {
        int SlashPos = iRDN.lastIndexOf("\\\\");
        String ReturnString = SlashPos == iRDN.length() - 2 ? iRDN.substring(0, SlashPos) : iRDN;
        return ReturnString;
    }

    public DirContext getContext() {
        return this.ctx;
    }
}

