/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.ds.security;

import java.security.Principal;
import java.security.acl.Group;
import nyla.solutions.core.security.data.SecurityGroup;
import nyla.solutions.core.util.Text;

public class LdapSecurityGroup
extends SecurityGroup {
    private static final long serialVersionUID = 9061501642280480803L;
    private final String primaryLdapGroupName;

    public LdapSecurityGroup(String dn) {
        this(dn, "CN");
    }

    public LdapSecurityGroup(String dn, String attributeName) {
        super(dn);
        dn = this.getName();
        if (attributeName == null) {
            this.primaryLdapGroupName = dn;
        } else {
            String startsWith = attributeName + "=";
            String results = Text.parseText(dn, startsWith, ",");
            results = results == null || results.length() == 0 ? dn : results.toUpperCase();
            this.primaryLdapGroupName = results;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.primaryLdapGroupName == null ? 0 : this.primaryLdapGroupName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (!Group.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Group other = (Group)obj;
        String otherGroupName = other.getName();
        if (otherGroupName == null) {
            return false;
        }
        if (this.primaryLdapGroupName == null) {
            return false;
        }
        return this.primaryLdapGroupName.equals(otherGroupName);
    }

    @Override
    public Boolean apply(Principal obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (!Group.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Group other = (Group)obj;
        String otherGroupName = other.getName();
        if (otherGroupName == null) {
            return false;
        }
        if (this.primaryLdapGroupName == null) {
            return false;
        }
        return this.primaryLdapGroupName.equals(otherGroupName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LdapSecurityGroup [primaryLdapGroupName=").append(this.primaryLdapGroupName).append(", getName()=").append(this.getName()).append("]");
        return builder.toString();
    }
}

