/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.exception;

import nyla.solutions.core.exception.SecurityException;

public class AuthenticationFailedFaultException
extends SecurityException {
    public static final String DEFAULT_ERROR_CODE = "SC0003";
    private String username = null;
    private static final long serialVersionUID = -3062061475584757100L;

    public AuthenticationFailedFaultException(Exception exception, String username) {
        super(exception);
        this.setCode(DEFAULT_ERROR_CODE);
        this.username = username;
    }

    public AuthenticationFailedFaultException(String message, String username) {
        super(message + " user:" + username);
        this.setCode(DEFAULT_ERROR_CODE);
        this.username = username;
    }

    public AuthenticationFailedFaultException(String message, Exception e, String username) {
        super(message + " user:" + username, e);
        this.setCode(DEFAULT_ERROR_CODE);
        this.username = username;
    }

    public AuthenticationFailedFaultException(String username) {
        super("Authentication Failed for user:" + username);
        this.setCode(DEFAULT_ERROR_CODE);
        this.username = username;
    }

    @Override
    public String toString() {
        return "AuthenticationFailedException [username=" + this.username + ", toString()=" + super.toString() + "]";
    }

    public String getUsername() {
        return this.username;
    }
}

