/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import nyla.solutions.core.io.FileEvent;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.io.WildCardFilter;
import nyla.solutions.core.util.Config;

public class FileMonitor
extends Observable {
    private Timer timer;
    private long pollingInterval = 1000L;

    public FileMonitor() {
        this(1000L);
    }

    public FileMonitor(long pollingInterval) {
        this.pollingInterval = pollingInterval;
        this.timer = new Timer(true);
    }

    public synchronized void stop() {
        this.timer.cancel();
    }

    public static void waitFor(File aFile) {
        long previousSize;
        if (aFile == null) {
            return;
        }
        String path = aFile.getAbsolutePath();
        long currentSize = previousSize = IO.getFileSize(path);
        long sleepTime = Config.getPropertyLong("file.monitor.file.wait.time", 100L);
        while (true) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            currentSize = IO.getFileSize(path);
            if (currentSize == previousSize) {
                return;
            }
            previousSize = currentSize;
        }
    }

    public synchronized void monitor(String directory, String fileNameFilter, boolean processCurrentFiles) {
        this.timer.schedule((TimerTask)new FileMonitorNotifier(this, directory, fileNameFilter, processCurrentFiles), 0L, this.pollingInterval);
    }

    protected synchronized void notifyChange(File file) {
        this.setChanged();
        System.out.println("Notify change file=" + file.getAbsolutePath());
        this.notifyObservers(FileEvent.createChangedEvent(file));
    }

    protected synchronized void notifyAdd(File file) {
        this.setChanged();
        System.out.println("Notify added file=" + file.getAbsolutePath());
        this.notifyObservers(FileEvent.createAddedEvent(file));
    }

    public static void main(String[] args) {
        try {
            FileMonitor.createFileMonitor(args);
        }
        catch (Exception e) {
            System.err.println("Unable monitor specified input error=" + e);
            System.exit(-1);
        }
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static FileMonitor createFileMonitor(String[] args) throws Exception {
        String usage = " Usage: [-pollingInterval <timems>]? [-observer <class>]* [-monitor <dir>:<filter>:<ignoreCurrentContentBoolean>]*";
        if (args == null || args.length < 2) {
            throw new IllegalArgumentException(usage);
        }
        FileMonitor fileMonitor = new FileMonitor();
        String[] arrayString = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-monitor".equals(args[i])) {
                if (i + 1 >= args.length) {
                    throw new IllegalArgumentException("directory:filter specified -monitor argument " + usage);
                }
                arrayString = args[i + 1].split(":");
                if (arrayString.length != 3) {
                    throw new IllegalArgumentException(args[i + 1] + usage);
                }
                fileMonitor.monitor(arrayString[0], arrayString[1], Boolean.valueOf(arrayString[2]));
                ++i;
                continue;
            }
            if ("-pollingInterval".equals(args[i])) {
                if (i + 1 >= args.length) {
                    throw new IllegalArgumentException("no time specified -pollingInterval argument " + usage);
                }
                fileMonitor.setPollingInterval(Long.parseLong(args[i + 1]));
                ++i;
                continue;
            }
            if (!"-observer".equals(args[i])) continue;
            if (i + 1 >= args.length) {
                throw new IllegalArgumentException("no observer specific in -observer argument " + usage);
            }
            fileMonitor.addObserver((Observer)Class.forName(args[i + 1]).newInstance());
            ++i;
        }
        return fileMonitor;
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    private static class FileMonitorNotifier
    extends TimerTask {
        private Hashtable<File, Object> fileLastModifyTimeMap = new Hashtable();
        private FilenameFilter filter = null;
        private File directory = null;
        private FileMonitor fileMonitor = null;

        FileMonitorNotifier(FileMonitor aFileMonitor, String aDirectory, String aFileFilter, boolean processCurrentFiles) {
            if (aDirectory == null || aDirectory.length() == 0) {
                throw new IllegalArgumentException("Directory to minotor has not provided.");
            }
            this.directory = new File(aDirectory);
            if (!this.directory.isDirectory()) {
                throw new IllegalArgumentException("Invalid directory \"" + aDirectory + "\" provided!");
            }
            if (aFileMonitor == null) {
                throw new IllegalArgumentException("FileMonitor not provided");
            }
            this.fileMonitor = aFileMonitor;
            this.filter = new WildCardFilter(aFileFilter);
            if (!processCurrentFiles) {
                this.init();
            }
        }

        private void init() {
            File[] files = this.directory.listFiles(this.filter);
            if (files == null) {
                return;
            }
            File file = null;
            for (int i = 0; i < files.length; ++i) {
                file = files[i];
                this.fileLastModifyTimeMap.put(file, file.lastModified());
            }
        }

        @Override
        public void run() {
            try {
                if (this.directory == null) {
                    return;
                }
                File[] filesInDir = this.directory.listFiles(this.filter);
                if (filesInDir == null) {
                    return;
                }
                File dirfile = null;
                Long lastModifiedTime = null;
                long newModifiedTime = 0L;
                ArrayList<String> processedFiles = new ArrayList<String>();
                for (int i = 0; i < filesInDir.length; ++i) {
                    dirfile = filesInDir[i];
                    if (processedFiles.contains(dirfile.getAbsolutePath())) continue;
                    lastModifiedTime = (Long)this.fileLastModifyTimeMap.get(dirfile);
                    if (lastModifiedTime == null) {
                        this.fileMonitor.notifyAdd(dirfile);
                    } else {
                        long l = newModifiedTime = dirfile.exists() ? dirfile.lastModified() : -1L;
                        if (newModifiedTime != lastModifiedTime) {
                            this.fileMonitor.notifyChange(dirfile);
                        }
                    }
                    this.fileLastModifyTimeMap.put(dirfile, dirfile.lastModified());
                    processedFiles.add(dirfile.getAbsolutePath());
                }
                List<File> filesInDirList = Arrays.asList(filesInDir);
                File fileInMap = null;
                Map.Entry<File, Object> mapEntry = null;
                Iterator<Map.Entry<File, Object>> i = this.fileLastModifyTimeMap.entrySet().iterator();
                while (i.hasNext()) {
                    try {
                        mapEntry = i.next();
                        fileInMap = mapEntry.getKey();
                        if (filesInDirList.contains(fileInMap)) continue;
                        System.out.println("File was removed " + fileInMap.getName());
                        i.remove();
                        System.out.println("DONE");
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

