/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.csv;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import nyla.solutions.core.patterns.conversion.Converter;
import nyla.solutions.core.util.Text;

public class BeanPropertiesToCsvConverter<ObjectType>
implements Converter<ObjectType, String> {
    private static final String GET_PREFIX = "get";
    private static final String SEPARATOR = ",";
    private static final String QUOTE = "\"";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    private TreeMap<String, Method> methods;
    private final String headerRow;

    public BeanPropertiesToCsvConverter(Class<ObjectType> objectClass) {
        Method[] methodArray = objectClass.getMethods();
        String methodName = null;
        this.methods = new TreeMap();
        for (int i = 0; i < methodArray.length; ++i) {
            Method m = methodArray[i];
            methodName = m.getName();
            if (!methodName.startsWith(GET_PREFIX) || m.getParameterCount() != 0) continue;
            this.methods.put(methodName, m);
        }
        StringBuilder csv = new StringBuilder();
        for (String keyMethodName : this.methods.keySet()) {
            if (csv.length() != 0) {
                csv.append(SEPARATOR);
            }
            csv.append(QUOTE).append(this.format(this.toFieldName(keyMethodName))).append(QUOTE);
        }
        csv.append(NEWLINE);
        this.headerRow = csv.toString();
    }

    public String getHeaderRow() {
        return this.headerRow;
    }

    @Override
    public String convert(ObjectType sourceObject) {
        if (sourceObject == null) {
            return null;
        }
        String methodName = null;
        Object value = null;
        StringBuilder csv = new StringBuilder();
        Object[] args = new Object[]{};
        for (Map.Entry<String, Method> entry : this.methods.entrySet()) {
            Method m = entry.getValue();
            methodName = m.getName();
            try {
                value = m.invoke(sourceObject, args);
                if (csv.length() != 0) {
                    csv.append(SEPARATOR);
                }
                csv.append(QUOTE).append(this.format(value)).append(QUOTE);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Unable to get property for method:" + methodName + " error:" + e.getMessage(), e);
            }
        }
        csv.append(NEWLINE);
        return csv.toString();
    }

    private String toFieldName(String methodName) {
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    private String format(Object object) {
        String text = Text.toString(object);
        return Text.replace(QUOTE, "\"\"", text);
    }
}

