/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nyla.solutions.core.io.csv.formulas.CsvFormula;

public class CsvReader {
    private final File file;
    private final ArrayList<List<String>> data;

    public CsvReader(File file) throws IOException {
        this.file = file;
        if (!file.exists()) {
            throw new IllegalArgumentException("File:" + this.file.getAbsolutePath() + " does not exist");
        }
        String line = null;
        this.data = new ArrayList();
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            while ((line = reader.readLine()) != null) {
                this.data.add(this.parse(line));
            }
        }
    }

    public <T> T get(int row, int col, DataType dataType) {
        List<String> rowList = this.row(row);
        if (rowList == null || rowList.isEmpty() || col >= rowList.size()) {
            return this.nullFor(dataType);
        }
        String cell = rowList.get(col);
        T results = this.toType(cell, dataType);
        return results;
    }

    private <T> T nullFor(DataType dataType) {
        switch (dataType) {
            case Long: {
                return (T)Long.valueOf(-1L);
            }
        }
        return null;
    }

    private <T> T toType(String cell, DataType dataType) {
        switch (dataType) {
            case Long: {
                return (T)(cell != null && cell.length() > 0 ? Long.valueOf(cell) : Long.valueOf(-1L));
            }
        }
        return (T)cell;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void calc(CsvFormula csvFormula) {
        csvFormula.calc(this);
    }

    private List<String> parse(String line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        String[] cells = line.split(",");
        for (int i = 0; i < cells.length; ++i) {
            cells[i] = cells[i].trim();
            if (!cells[i].startsWith("\"")) continue;
            int startIndex = 1;
            int endIndex = cells[i].length();
            if (cells[i].endsWith("\"")) {
                --endIndex;
            }
            cells[i] = cells[i].substring(startIndex, endIndex).replace("\"\"", "\"");
        }
        if (cells == null || cells.length == 0) {
            return Collections.singletonList(line);
        }
        return Arrays.asList(cells);
    }

    public List<String> row(int rowNumber) {
        List<String> row = this.data.get(rowNumber);
        if (row == null) {
            return null;
        }
        return new ArrayList<String>(row);
    }

    public void sortRowsForIndexByType(int index, DataType dataType) {
        Comparator comparator = null;
        switch (dataType) {
            case Long: {
                comparator = (list1, list2) -> Long.valueOf((String)list1.get(0)).compareTo(Long.valueOf((String)list2.get(0)));
                break;
            }
            default: {
                comparator = (list1, list2) -> ((String)list1.get(0)).compareTo((String)list2.get(0));
            }
        }
        this.sortRows(comparator);
    }

    public void sortRows(Comparator<List<String>> comparator) {
        if (this.data.isEmpty()) {
            return;
        }
        Collections.sort(this.data, comparator);
    }

    public int size() {
        return this.data.size();
    }

    public static enum DataType {
        String,
        Long;

    }
}

