/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.csv;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Text;

public class CsvWriter {
    public static final String SEPARATOR = Config.getProperty(CsvWriter.class.getName() + ".separator", ",");
    private final File file;
    private String replacement = Config.getProperty(this.getClass().getName() + ".replacement", "");

    public CsvWriter(File file) {
        this.file = file;
    }

    public void appendRow(String ... cells) throws IOException {
        if (cells == null) {
            return;
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < cells.length; ++i) {
            if (i != 0) {
                text.append(SEPARATOR);
            }
            text.append("\"").append(CsvWriter.format(cells[i])).append("\"");
        }
        IO.writeAppend(this.file, text.toString() + IO.newline());
    }

    public void appendRow(List<String> row) throws IOException {
        if (row == null) {
            throw new RequiredException("objects in CSV.toRow");
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < row.size(); ++i) {
            if (i != 0) {
                text.append(SEPARATOR);
            }
            text.append("\"").append(CsvWriter.format(row.get(i))).append("\"");
        }
        IO.writeAppend(this.file, text.toString() + IO.newline());
    }

    public static String toCell(String text) {
        return "\"" + CsvWriter.format(text) + "\"";
    }

    public String toRow(Object[] objects) {
        if (objects == null) {
            throw new RequiredException("objects in CSV.toRow");
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i != 0) {
                text.append(SEPARATOR);
            }
            text.append("\"").append(CsvWriter.format(objects[i])).append("\"");
        }
        return text.toString() + IO.newline();
    }

    private static String format(Object object) {
        String text = Text.toString(object);
        return Text.replace("\"", "\"\"", text);
    }

    public void writeHeader(String ... header) throws IOException {
        this.writeHeader(this.toRow(header), IO.CHARSET);
    }

    public void writeHeader(List<String> header) throws IOException {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < header.size(); ++i) {
            if (i != 0) {
                text.append(SEPARATOR);
            }
            text.append("\"").append(CsvWriter.format(header.get(i))).append("\"");
        }
        this.writeHeader(text.toString(), IO.CHARSET);
    }

    public void writeHeader(String header, Charset charset) throws IOException {
        if (!this.file.exists() && header != null) {
            IO.writeFile(this.file, Text.appendNewLine(header), charset);
        }
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public static void addCell(StringBuilder builder, String cell) {
        if (builder.length() != 0) {
            builder.append(SEPARATOR);
        }
        builder.append(CsvWriter.toCell(cell));
    }
}

