/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.csv.formulas;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Paths;
import java.util.ArrayList;
import nyla.solutions.core.io.csv.CsvReader;
import nyla.solutions.core.io.csv.formulas.CsvFormula;
import nyla.solutions.core.util.Organizer;
import nyla.solutions.core.util.stats.Mathematics;

public class SumStatsByMillisecondsFormular
implements CsvFormula {
    private final int timeMsIndex;
    private final int calculateColumn;
    private BigInteger sum = BigInteger.ZERO;
    private BigInteger sumByMillisec = BigInteger.ZERO;
    private final long milliseconds;
    private long currentVal = -1L;
    private long count = 0L;
    private double avg = -1.0;
    private ArrayList<Double> averages = new ArrayList();
    private long max = -1L;
    private long min = -1L;

    public SumStatsByMillisecondsFormular(int timeMsIndex, int calculateColumn, long milliseconds) {
        this.timeMsIndex = timeMsIndex;
        this.calculateColumn = calculateColumn;
        this.milliseconds = milliseconds;
    }

    @Override
    public void calc(CsvReader reader) {
        if (reader == null || reader.isEmpty()) {
            return;
        }
        this.init();
        reader.sortRowsForIndexByType(this.timeMsIndex, CsvReader.DataType.Long);
        long startTsMS = -1L;
        int size = reader.size();
        for (int i = 0; i < size; ++i) {
            long tsMS = (Long)reader.get(i, this.timeMsIndex, CsvReader.DataType.Long);
            this.currentVal = (Long)reader.get(i, this.calculateColumn, CsvReader.DataType.Long);
            if (startTsMS == -1L) {
                startTsMS = tsMS;
                this.addInMillsec();
                continue;
            }
            if (tsMS - startTsMS <= this.milliseconds) {
                this.addInMillsec();
                continue;
            }
            if (tsMS - startTsMS <= this.milliseconds) continue;
            this.incrementStat();
            startTsMS = tsMS;
        }
        this.incrementStat();
    }

    private void addInMillsec() {
        this.sumByMillisec = this.sumByMillisec.add(BigInteger.valueOf(this.currentVal));
    }

    private void incrementStat() {
        ++this.count;
        this.sum = this.sum.add(this.sumByMillisec);
        this.max = this.max != -1L ? Math.max(this.sumByMillisec.longValue(), this.max) : this.sumByMillisec.longValue();
        this.min = this.min != -1L ? Math.min(this.sumByMillisec.longValue(), this.min) : this.sumByMillisec.longValue();
        this.avg = this.avg != -1.0 ? (double)this.sum.divide(BigInteger.valueOf(this.count)).longValue() : (double)this.sumByMillisec.longValue();
        this.averages.add(this.avg);
        this.sumByMillisec = BigInteger.valueOf(this.currentVal);
    }

    public double getAvg() {
        return this.avg;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public double getStdDev() {
        double[] avgs = Organizer.toDoubles(this.averages);
        return Mathematics.stdDev(avgs);
    }

    private void init() {
        this.sum = BigInteger.ZERO;
        this.sumByMillisec = BigInteger.ZERO;
        this.currentVal = -1L;
        this.count = 0L;
        this.avg = -1.0;
        this.max = -1L;
        this.min = -1L;
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage java " + SumStatsByMillisecondsFormular.class.getName() + " file msSecColumn calculateCol sumByMillisec");
            System.exit(-1);
        }
        File file = Paths.get(args[0], new String[0]).toFile();
        try {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            int timeMsIndex = Integer.parseInt(args[1]);
            int calculateColumn = Integer.parseInt(args[2]);
            long milliseconds = Long.parseLong(args[3]);
            SumStatsByMillisecondsFormular formular = new SumStatsByMillisecondsFormular(timeMsIndex, calculateColumn, milliseconds);
            new CsvReader(file).calc(formular);
            System.out.println(formular);
        }
        catch (NumberFormatException e) {
            System.err.println("Checks timeMsIndex:" + args[1] + ",calculateColumn:" + args[2] + " and milliseconds:" + args[3] + " are valids numbers error:" + e);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SumStatsByMillisecondsFormular [milliseconds=").append(this.milliseconds).append(", timeMsIndex=").append(this.timeMsIndex).append(", calculateColumn=").append(this.calculateColumn).append(", avg=").append(this.avg).append(", max=").append(this.max).append(", min=").append(this.min).append(", stdDev=").append(this.getStdDev()).append("]");
        return builder.toString();
    }
}

