/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.media;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.util.Debugger;

public class Graphics {
    private static Robot robot = null;

    public static void rotateImage(File input, File output, String format, int degrees) throws IOException {
        BufferedImage inputImage = ImageIO.read(input);
        Graphics2D g = (Graphics2D)inputImage.getGraphics();
        g.drawImage((Image)inputImage, 0, 0, null);
        AffineTransform at = new AffineTransform();
        at.rotate((double)degrees * Math.PI / 180.0, (double)inputImage.getWidth() / 2.0, (double)inputImage.getHeight() / 2.0);
        AffineTransform translationTransform = Graphics.findTranslation(at, inputImage);
        at.preConcatenate(translationTransform);
        AffineTransformOp bio = new AffineTransformOp(at, 2);
        BufferedImage destinationBI = bio.filter(inputImage, null);
        ImageIO.write((RenderedImage)destinationBI, format, output);
    }

    private static AffineTransform findTranslation(AffineTransform at, BufferedImage bi) {
        Point2D.Double p2din = new Point2D.Double(0.0, 0.0);
        Point2D p2dout = at.transform(p2din, null);
        double ytrans = p2dout.getY();
        p2din = new Point2D.Double(0.0, bi.getHeight());
        p2dout = at.transform(p2din, null);
        double xtrans = p2dout.getX();
        AffineTransform tat = new AffineTransform();
        tat.translate(-xtrans, -ytrans);
        return tat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printScreen(int x, int y, int width, int height, String format, File file) {
        try {
            if (robot == null) {
                robot = new Robot();
            }
            Robot robot = Graphics.robot;
            synchronized (robot) {
                Rectangle rect = new Rectangle(x, y, width, height);
                BufferedImage image = Graphics.robot.createScreenCapture(rect);
                ImageIO.write((RenderedImage)image, format, file);
            }
        }
        catch (Exception e) {
            throw new SystemException(Debugger.stackTrace(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printScreen(int x, int y, int width, int height, String format, OutputStream outputStream) {
        try {
            if (robot == null) {
                robot = new Robot();
            }
            Robot robot = Graphics.robot;
            synchronized (robot) {
                Rectangle rect = new Rectangle(x, y, width, height);
                BufferedImage image = Graphics.robot.createScreenCapture(rect);
                ImageIO.write((RenderedImage)image, format, outputStream);
            }
        }
        catch (Exception e) {
            throw new SystemException(Debugger.stackTrace(e));
        }
    }
}

