/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.operations;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.exception.fault.ClassNotFoundFaultException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.util.Debugger;

public class ClassPath
extends ClassLoader {
    private Hashtable<String, Class<?>> classes = new Hashtable();

    public ClassPath() {
        super(ClassPath.class.getClassLoader());
    }

    public static String getClassPathText() {
        return System.getProperty("java.class.path");
    }

    public static Class<?> toClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (Integer.TYPE.getName().equals(className)) {
                return Integer.TYPE;
            }
            if (Long.TYPE.getName().equals(className)) {
                return Long.TYPE;
            }
            if (Short.TYPE.getName().equals(className)) {
                return Short.TYPE;
            }
            if (Double.TYPE.getName().equals(className)) {
                return Double.TYPE;
            }
            if (Float.TYPE.getName().equals(className)) {
                return Float.TYPE;
            }
            throw new ClassNotFoundFaultException("\"" + className + "\"");
        }
    }

    public static boolean isPrimitive(Field field) {
        if (field == null) {
            return false;
        }
        String fieldName = field.getName();
        if ("serialVersionUID".equals(fieldName)) {
            return false;
        }
        return ClassPath.isPrimitive(field.getType());
    }

    public static boolean isPrimitive(Class<?> aClass) {
        if (aClass == null) {
            return false;
        }
        String className = aClass.getName();
        return className.matches("(float|char|short|double|int|long|byte|boolean|(java.lang.(Date|Long|Integer|String|Float|Double|Short|Byte|Boolean)))");
    }

    public static <T> T newInstance(String className) {
        return ClassPath.newInstance(ClassPath.toClass(className));
    }

    public static <T> T newInstance(String className, Class<?> parameterType, Object initarg) throws SetupException {
        try {
            return ClassPath.newInstance(Class.forName(className), parameterType, initarg);
        }
        catch (ClassNotFoundException e) {
            throw new SetupException(e);
        }
    }

    public static <T> T newInstance(Class<?> aClass, Class<?> parameterType, Object initarg) throws SetupException {
        Class[] paramTypes = new Class[]{parameterType};
        Object[] initArgs = new Object[]{initarg};
        return ClassPath.newInstance(aClass, paramTypes, initArgs);
    }

    public static <T> T newInstance(String className, Object[] initargs) throws SetupException {
        return ClassPath.newInstance(ClassPath.toClass(className), initargs);
    }

    public static <T> T newInstance(Class<?> aClass, Object[] initargs) throws SetupException {
        Class[] parameterTypes = null;
        if (initargs != null && initargs.length > 0) {
            parameterTypes = new Class[initargs.length];
            for (int i = 0; i < initargs.length; ++i) {
                if (initargs[i] == null) continue;
                parameterTypes[i] = initargs[i].getClass();
            }
        }
        return ClassPath.newInstance(aClass, parameterTypes, initargs);
    }

    public static <T> T newInstance(Class<?> aClass, Class<?>[] parameterTypes, Object[] initargs) throws SetupException {
        try {
            Constructor<?> constructor = aClass.getConstructor(parameterTypes);
            return (T)constructor.newInstance(initargs);
        }
        catch (Exception e) {
            throw new SetupException(e);
        }
    }

    public static <T> T newInstance(Class<?> aClass) {
        if (aClass == null) {
            return null;
        }
        try {
            if (String.class.equals(aClass)) {
                return (T)"";
            }
            if (Integer.class.equals(aClass)) {
                return (T)Integer.valueOf(0);
            }
            if (Date.class.equals(aClass)) {
                return (T)Calendar.getInstance().getTime();
            }
            if (Long.class.equals(aClass)) {
                return (T)Long.valueOf(0L);
            }
            if (Character.class.equals(aClass)) {
                return (T)Character.valueOf('\u0000');
            }
            if (Float.class.equals(aClass)) {
                return (T)new Float(0.0f);
            }
            if (Double.class.equals(aClass)) {
                return (T)Double.valueOf(0.0);
            }
            return (T)aClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SetupException("Trying to create " + aClass.getName() + " " + e.getMessage());
        }
        catch (InstantiationException e) {
            Constructor<?>[] constructors = aClass.getConstructors();
            int len = constructors.length;
            for (int i = 0; i < len; ++i) {
                Class<?>[] parameterTypes = constructors[i].getParameterTypes();
                if (parameterTypes == null || parameterTypes.length == 0) {
                    throw new SetupException("Trying to create " + aClass.getName() + " " + e.getMessage());
                }
                Object[] initargs = new Object[parameterTypes.length];
                for (int argsIndex = 0; argsIndex < initargs.length; ++argsIndex) {
                    initargs[argsIndex] = ClassPath.newInstance(parameterTypes[argsIndex]);
                }
                try {
                    return (T)constructors[i].newInstance(initargs);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            throw new SetupException("Trying to create " + aClass.getName() + " " + e.getMessage());
        }
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.findClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJar(File fileJar) throws IOException {
        JarFile jar = null;
        try {
            jar = new JarFile(fileJar);
            Enumeration<JarEntry> enumerations = jar.entries();
            JarEntry entry = null;
            byte[] classByte = null;
            ByteArrayOutputStream byteStream = null;
            String fileName = null;
            String className = null;
            Class<?> jarClass = null;
            while (enumerations.hasMoreElements()) {
                entry = enumerations.nextElement();
                if (entry.isDirectory() || !(fileName = entry.getName()).endsWith(".class")) continue;
                InputStream is = jar.getInputStream(entry);
                byteStream = new ByteArrayOutputStream();
                IO.write(byteStream, is);
                classByte = byteStream.toByteArray();
                className = ClassPath.formatClassName(fileName);
                Debugger.println(this, "className=" + className);
                jarClass = this.defineClass(className, classByte, 0, classByte.length, null);
                this.classes.put(className, jarClass);
                classByte = null;
                byteStream = null;
            }
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String formatClassName(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        String className = fileName.replace('/', '.');
        return className.replace(".class", "");
    }

    @Override
    public Class<?> findClass(String className) {
        Class<?> result = null;
        result = this.classes.get(className);
        if (result != null) {
            return result;
        }
        try {
            return this.findSystemClass(className);
        }
        catch (Exception e) {
            Debugger.printWarn(e);
            try {
                URL resourceURL = ClassLoader.getSystemResource(className.replace('.', File.separatorChar) + ".class");
                if (resourceURL == null) {
                    return null;
                }
                String classPath = resourceURL.getFile();
                classPath = classPath.substring(1);
                return this.loadClass(className, new File(classPath));
            }
            catch (Exception e2) {
                Debugger.printError(e2);
                return null;
            }
        }
    }

    public Class<?> loadClass(String className, File classPathFile) throws IOException, ClassFormatError {
        byte[] classBytes = this.loadClassBytes(classPathFile);
        Class<?> result = this.defineClass(className, classBytes, 0, classBytes.length, null);
        this.classes.put(className, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassBytes(File classFile) throws IOException {
        int size = (int)classFile.length();
        byte[] buff = new byte[size];
        FileInputStream fis = new FileInputStream(classFile);
        try (DataInputStream dis = null;){
            dis = new DataInputStream(fis);
            dis.readFully(buff);
        }
        return buff;
    }
}

