/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.cache;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import nyla.solutions.core.exception.NoDataFoundException;
import nyla.solutions.core.exception.NotImplementedException;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.patterns.cache.Cache;

public class CacheFarm<K, V>
implements Cache<K, V>,
Cloneable {
    private static Cache<Object, Object> cache = null;
    private WeakHashMap<K, V> map = new WeakHashMap();

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean contains(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Enumeration<V> elements() {
        throw new NotImplementedException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Enumeration<K> keys() {
        throw new NotImplementedException();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    public static Cache<Object, Object> getCache() {
        if (cache == null) {
            cache = new CacheFarm<Object, Object>();
        }
        return cache;
    }

    @Override
    public Object getObject(Class<?> objClass) throws NoDataFoundException {
        String name = objClass.getName();
        V obj = this.get(objClass.getName());
        if (obj == null) {
            throw new NoDataFoundException("name=" + name + " no found in keys=" + this.map.keySet());
        }
        return obj;
    }

    @Override
    public void setObject(Class<?> objClass, V obj) {
        if (objClass == null) {
            throw new RequiredException("objClass in CacheFarm");
        }
        if (obj == null) {
            throw new RequiredException("obj in CacheFarm");
        }
        this.map.put(objClass.getName(), obj);
    }

    @Override
    public void removeObject(Class<?> objClass) {
        this.map.remove(objClass.getName());
    }
}

