/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.builder.mapped;

import java.util.Map;
import nyla.solutions.core.exception.NoDataFoundException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.patterns.creational.builder.mapped.MapFactoryById;
import nyla.solutions.core.patterns.creational.builder.mapped.MappedKeyEngineer;
import nyla.solutions.core.patterns.servicefactory.ServiceFactory;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;

public class MappedKeyDirector<K, V> {
    private String mapFactoryByIdServiceName = Config.getProperty(this.getClass(), "mapFactoryByIdServiceName", MapFactoryById.class.getName());

    protected Map<K, V> constructMapToText(String path) throws NoDataFoundException {
        MapFactoryById factory = (MapFactoryById)ServiceFactory.getInstance().create(this.mapFactoryByIdServiceName);
        factory.setId(path);
        return factory.createMap();
    }

    public void constructDocument(String id, MappedKeyEngineer<K, V> engineer) {
        try {
            Map<K, V> textableMap = this.constructMapToText(id);
            engineer.construct(id, textableMap);
        }
        catch (NoDataFoundException e) {
            throw new SystemException("No textable found for id=" + id + " ERROR:" + Debugger.stackTrace(e));
        }
    }

    public String getMapFactoryByIdServiceName() {
        return this.mapFactoryByIdServiceName;
    }

    public void setMapFactoryByIdServiceName(String mapFactoryByIdServiceName) {
        this.mapFactoryByIdServiceName = mapFactoryByIdServiceName;
    }
}

