/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.iteration;

import java.io.Serializable;
import nyla.solutions.core.data.Identifier;

public class PageCriteria
implements Identifier,
Serializable {
    private static final long serialVersionUID = -5876945310432037628L;
    private String id = null;
    private int beginIndex = 1;
    private int size;
    private boolean savePagination;
    private String className;

    public PageCriteria() {
    }

    public PageCriteria(int beginIndex, int size) {
        this.beginIndex = beginIndex;
        this.size = size;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public void setBeginIndex(int beginIndex) {
        if (beginIndex < 1) {
            throw new IllegalArgumentException("Begin index must be greater than 1");
        }
        this.beginIndex = beginIndex;
    }

    public void first() {
        this.beginIndex = 1;
    }

    public int getEndIndex() {
        return this.beginIndex + this.size;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void incrementPage() {
        PageCriteria.incrementPage(this);
    }

    public static void incrementPage(PageCriteria pageCriteria) {
        pageCriteria.beginIndex += pageCriteria.size;
    }

    public String toString() {
        return "PageCriteria [id=" + this.id + ", beginIndex=" + this.beginIndex + ", size=" + this.size + ", savePagination=" + this.savePagination + ", className=" + this.className + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.beginIndex;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.savePagination ? 1231 : 1237);
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageCriteria other = (PageCriteria)obj;
        if (this.beginIndex != other.beginIndex) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.savePagination != other.savePagination) {
            return false;
        }
        return this.size == other.size;
    }

    public boolean hasIdentifier() {
        return this.id != null && this.id.length() > 0;
    }

    public void firstPage() {
        this.beginIndex = 1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public boolean isSavePagination() {
        return this.savePagination;
    }

    public void setSavePagination(boolean savePagination) {
        this.savePagination = savePagination;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

