/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.iteration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import nyla.solutions.core.data.Identifier;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.Disposable;
import nyla.solutions.core.patterns.creational.RowObjectCreator;
import nyla.solutions.core.patterns.iteration.PageCriteria;
import nyla.solutions.core.patterns.iteration.Paging;
import nyla.solutions.core.util.Config;

public abstract class Pagination
implements Identifier,
Disposable {
    private static String paginationClassName = Config.getProperty(Pagination.class, "paginationClassName", "nyla.solutions.dao.mongodb.MongoPagination");
    private final String id;
    private static Map<String, Pagination> paginationMap = new HashMap<String, Pagination>();

    protected Pagination(String id) {
        this.id = id;
        this.save();
    }

    public abstract <ObjectType> void store(ObjectType var1, PageCriteria var2);

    public static <StoredObjectType, ResultSetType> Pagination createPagination(PageCriteria pageCriteria) {
        String id = pageCriteria.getId();
        if (id == null || id.length() == 0) {
            return null;
        }
        Pagination pagination = (Pagination)ClassPath.newInstance(paginationClassName, String.class, (Object)pageCriteria.getId());
        paginationMap.put(id, pagination);
        return pagination;
    }

    public abstract <IterationObjectType, CreatedObjectType> void constructPaging(Iterator<IterationObjectType> var1, PageCriteria var2, RowObjectCreator<CreatedObjectType, IterationObjectType> var3);

    public void waitForCompletion() {
        try {
            Set<Future<?>> futures = this.getFutures();
            if (futures == null) {
                return;
            }
            for (Future<?> future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new SystemException("Error while wating for results " + e.getMessage(), e);
        }
    }

    public static Pagination getPaginationById(String id) {
        if (id == null) {
            return null;
        }
        return paginationMap.get(id);
    }

    @Override
    public void dispose() {
        this.cancel();
        this.removePaginationById(this.getId());
    }

    public static Pagination getPagination(PageCriteria pageCriteria) {
        if (pageCriteria == null) {
            return null;
        }
        String id = pageCriteria.getId();
        Pagination pagination = Pagination.getPaginationById(id);
        if (pagination == null) {
            pagination = Pagination.createPagination(pageCriteria);
        }
        return pagination;
    }

    protected Pagination removePaginationById(String id) {
        return paginationMap.remove(id);
    }

    public abstract <ReturnTypes> Paging<ReturnTypes> getPaging(PageCriteria var1, Class<?> var2);

    public <ReturnTypes> Paging<ReturnTypes> getPaging(PageCriteria pageCriteria) {
        try {
            String className = pageCriteria.getClassName();
            Class<?> classT = Class.forName(className);
            return this.getPaging(pageCriteria, classT);
        }
        catch (ClassNotFoundException e) {
            throw new SetupException(e.getMessage(), e);
        }
    }

    public abstract long count(PageCriteria var1);

    public abstract void clear();

    public abstract long size();

    public abstract void cancel();

    public abstract Set<Future<?>> getFutures();

    private void save() {
        paginationMap.put(this.getId(), this);
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final void setId(String id) {
    }
}

