/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import nyla.solutions.core.patterns.Disposable;
import nyla.solutions.core.patterns.jmx.JMXConnectionException;
import nyla.solutions.core.patterns.jmx.JMXSecurityException;
import nyla.solutions.core.patterns.jmx.JmxSecurity;

public class JMX
implements AutoCloseable,
Disposable {
    private static final String MemoryMX_NAME = "java.lang:type=Memory";
    private static final String ThreadMX_NAME = "java.lang:type=Threading";
    private final JMXConnector jmxc;
    private boolean disposed = false;
    private final MBeanServerConnection connection;
    private final String host;
    private final int port;

    public String getSystemProperty(String key) throws MalformedObjectNameException, InstanceNotFoundException {
        TabularData td = (TabularData)this.getAttribute(new ObjectName("java.lang:type=Runtime"), "SystemProperties");
        Object[] keyArray = new String[]{key};
        CompositeData cd = td.get(keyArray);
        return this.toText(cd);
    }

    public String toText(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        Object property = cd.get("value");
        return String.valueOf(property);
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) {
        return this.invoke(null, objectName, operationName, params, signature);
    }

    public Object invoke(Class<?> interfaceClass, ObjectName objectName, String operationName, Object[] params, String[] signature) {
        try {
            if (interfaceClass != null) {
                javax.management.JMX.newMBeanProxy(this.connection, objectName, interfaceClass);
            }
            return this.connection.invoke(objectName, operationName, params, signature);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke objectName:" + objectName + " operationName:" + operationName, e);
        }
    }

    public <T> T newBean(Class<?> interfaceClass, ObjectName objectName) {
        if (interfaceClass == null) {
            return null;
        }
        return (T)javax.management.JMX.newMBeanProxy(this.connection, objectName, interfaceClass);
    }

    public <T> T getAttribute(ObjectName objectName, String attribute) throws InstanceNotFoundException {
        try {
            return (T)this.connection.getAttribute(objectName, attribute);
        }
        catch (InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get attributes objectName:" + objectName + " attribute:" + attribute, e);
        }
    }

    private JMX(String host, int port, String userName, char[] password) {
        this.host = host;
        this.port = port;
        String connectionURL = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", host, port);
        if (connectionURL == null || connectionURL.length() == 0) {
            throw new IllegalArgumentException("connectionURL");
        }
        try {
            JMXServiceURL url = new JMXServiceURL(connectionURL);
            HashMap<String, String[]> map = null;
            if (userName != null && userName.length() > 0) {
                map = new HashMap<String, String[]>();
                if (password == null || password.length == 0) {
                    throw new SecurityException("password required");
                }
                String[] credentials = new String[]{userName, new String(password)};
                map.put("jmx.remote.credentials", credentials);
            }
            this.jmxc = JMXConnectorFactory.connect(url, map);
            this.connection = this.jmxc.getMBeanServerConnection();
        }
        catch (SecurityException e) {
            if (userName == null || userName.length() == 0 || password == null || password.length == 0) {
                throw new JMXSecurityException("Security exception: Add jmx.properties  to classpath the provide valid values for properties \"jmx-security-username\" and \"jmx-security-userPassword\"");
            }
            throw new JMXSecurityException("Cannot authenticate username:" + userName + " to connectionURL=" + connectionURL + " error:" + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new JMXConnectionException("Cannot connect to URL=" + connectionURL + " ERROR:" + e.getMessage(), e);
        }
    }

    public static List<String> getLocalRuntimeArguments() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments();
    }

    public static JMX connect(String host, int port) {
        return JMX.connect(host, port, JmxSecurity.getJmxUserName(), JmxSecurity.getJmxPassword());
    }

    public static JMX connect(String host, int port, String user, char[] password) {
        return new JMX(host, port, user, password);
    }

    public String[] getDomains() throws IOException {
        return this.connection.getDomains();
    }

    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) throws IOException {
        return this.jmxc.getMBeanServerConnection().queryMBeans(objectName, queryExp);
    }

    public static void main(String[] args) throws Exception {
        String host = null;
        String userName = null;
        char[] password = null;
        if (args.length < 2) {
            System.out.println("Usage java " + JMX.class.getCanonicalName() + " host port (userName password)?");
            System.exit(-1);
        }
        host = args[0];
        int port = Integer.parseInt(args[1]);
        if (args.length > 2) {
            if (args.length < 4) {
                System.out.println("Usage java " + JMX.class.getCanonicalName() + " host port userName password");
                System.exit(-1);
            }
            userName = args[2];
            password = args[3].toCharArray();
        }
        JMX jmx = JMX.connect(host, port, userName, password);
        System.out.println("\nDomains:");
        Object[] domains = jmx.getDomains();
        Arrays.sort(domains);
        for (int i = 0; i < domains.length; ++i) {
            System.out.println("\tDomain = " + (String)domains[i]);
        }
        System.out.println("\nMBeanServer default domain = " + jmx.getDefaultDomain());
        System.out.println("\nMBean count = " + jmx.getMBeanCount());
        System.out.println("\nQuery MBeanServer MBeans:");
        Set<ObjectName> names = jmx.searchObjectNames(null);
        ObjectName objectName2 = null;
        for (ObjectName objectName2 : names) {
            System.out.println("getCanonicalName=" + objectName2.getCanonicalName());
        }
        System.out.println("=========Memory Usage=========");
        MemoryMXBean memory = jmx.getMemory();
        System.out.println("memory.getObjectPendingFinalizationCount=" + memory.getObjectPendingFinalizationCount());
        MemoryUsage memoryUsage = memory.getHeapMemoryUsage();
        System.out.println("memory.getCommitted=" + memoryUsage.getCommitted());
        System.out.println("memory.getUsed=" + memoryUsage.getUsed());
        System.out.println("=========Thread Usage=========");
        ThreadMXBean thread = jmx.getThread();
        System.out.println("thread.getPeakThreadCount=" + thread.getPeakThreadCount());
        System.out.println("thread.getDaemonThreadCount=" + thread.getDaemonThreadCount());
        System.out.println("thread.getThreadCount=" + thread.getThreadCount());
        System.out.println("thread.getTotalStartedThreadCount=" + thread.getTotalStartedThreadCount());
        jmx.registerMemoryNotifications(new ClientListener(), null);
        System.out.println("Enter key to exit");
        System.in.read();
    }

    public String getDefaultDomain() throws IOException {
        return this.connection.getDefaultDomain();
    }

    public Integer getMBeanCount() throws IOException {
        return this.connection.getMBeanCount();
    }

    public Set<ObjectName> searchObjectNames(String objectNamePattern) {
        return this.searchObjectNames(objectNamePattern, null);
    }

    public Set<ObjectName> searchObjectNames(String objectNamePattern, QueryExp queryExp) {
        try {
            ObjectName objectName = null;
            if (objectNamePattern != null) {
                objectName = new ObjectName(objectNamePattern);
            }
            return this.connection.queryNames(objectName, queryExp);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid objectNamePattern" + objectNamePattern, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to query names with objectNamePattern:" + objectNamePattern, e);
        }
    }

    public MemoryMXBean getMemory() {
        try {
            return ManagementFactory.newPlatformMXBeanProxy(this.connection, MemoryMX_NAME, MemoryMXBean.class);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ThreadMXBean getThread() {
        try {
            return ManagementFactory.newPlatformMXBeanProxy(this.connection, ThreadMX_NAME, ThreadMXBean.class);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            try {
                this.jmxc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.disposed = true;
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object handback) throws InstanceNotFoundException, IOException {
        this.connection.addNotificationListener(objectName, notificationListener, notificationFilter, handback);
    }

    public void registerMemoryNotifications(NotificationListener notificationListener, Object handback) {
        NotificationEmitter emitter = (NotificationEmitter)((Object)this.getMemory());
        emitter.addNotificationListener(notificationListener, null, handback);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public static class ClientListener
    implements NotificationListener {
        @Override
        public void handleNotification(Notification notification, Object handback) {
            System.out.println("\nReceived notification:");
            System.out.println("\tClassName: " + notification.getClass().getName());
            System.out.println("\tSource: " + notification.getSource());
            System.out.println("\tType: " + notification.getType());
            System.out.println("\tMessage: " + notification.getMessage());
            if (notification instanceof AttributeChangeNotification) {
                AttributeChangeNotification acn = (AttributeChangeNotification)notification;
                System.out.println("\tAttributeName: " + acn.getAttributeName());
                System.out.println("\tAttributeType: " + acn.getAttributeType());
                System.out.println("\tNewValue: " + acn.getNewValue());
                System.out.println("\tOldValue: " + acn.getOldValue());
            }
        }
    }
}

