/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.jmx;

import java.nio.charset.Charset;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class JmxSecurity {
    public static final String JMX_USERNAME_PROP = "jmx-security-username";
    public static final String JMX_PASSWORD_PROP = "jmx-security-userPassword";
    private static final String ENCRYPTED_PASSWORD_PREFIX = "encrypted(";
    private static final String ENCRYPTED_PASSWORD_SUFFIX = ")";
    private static final String CIPHER_INSTANCE = "Blowfish";
    private static byte[] init = "string".getBytes(Charset.forName("UTF8"));
    public static final String JMX_PROPERTY_FILE_NM = "jmx.properties";
    private static ResourceBundle _bundle = null;

    public static char[] encrypt(char[] password) {
        if (password == null || password.length == 0) {
            return null;
        }
        try {
            String encryptedString = null;
            SecretKeySpec key = new SecretKeySpec(init, CIPHER_INSTANCE);
            Cipher cipher = Cipher.getInstance(CIPHER_INSTANCE);
            cipher.init(1, key);
            byte[] encrypted = cipher.doFinal(String.valueOf(password).getBytes(Charset.forName("UTF8")));
            encryptedString = JmxSecurity.byteArrayToHexString(encrypted);
            return encryptedString.toCharArray();
        }
        catch (Exception e) {
            throw new SecurityException("Unable to encrypt password", e);
        }
    }

    public static String decorateEncryption(char[] password) {
        if (password == null || password.length == 0) {
            return null;
        }
        return ENCRYPTED_PASSWORD_PREFIX + JmxSecurity.encrypt(password) + ENCRYPTED_PASSWORD_SUFFIX;
    }

    private static synchronized ResourceBundle getProperties() {
        if (_bundle == null) {
            _bundle = ResourceBundle.getBundle("jmx");
        }
        return _bundle;
    }

    public static char[] decrypt(char[] password) {
        if (password == null || password.length == 0) {
            return null;
        }
        String passwordString = String.valueOf(password);
        try {
            byte[] decrypted = null;
            if (passwordString.startsWith(ENCRYPTED_PASSWORD_PREFIX) && passwordString.endsWith(ENCRYPTED_PASSWORD_SUFFIX)) {
                passwordString = passwordString.substring(10, passwordString.length() - 1);
            }
            SecretKeySpec key = new SecretKeySpec(init, CIPHER_INSTANCE);
            Cipher cipher = Cipher.getInstance(CIPHER_INSTANCE);
            cipher.init(2, key);
            decrypted = cipher.doFinal(JmxSecurity.hexStringToByteArray(passwordString));
            return new String(decrypted, Charset.forName("UTF8")).toCharArray();
        }
        catch (Exception e) {
            throw new SecurityException("Unable to decrypt password. Check that the password has been encrypted.", e);
        }
    }

    public static String getJmxUserName() {
        try {
            String username = JmxSecurity.getProperties().getString(JMX_USERNAME_PROP);
            if (username == null || username.length() == 0) {
                return null;
            }
            return username;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static char[] getJmxPassword() {
        try {
            String password = JmxSecurity.getProperties().getString(JMX_PASSWORD_PROP);
            if (password == null || password.length() == 0) {
                return null;
            }
            return JmxSecurity.decrypt(password.toCharArray());
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    private static byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
        }
        return b;
    }
}

