/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.loadbalancer;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.patterns.SetUpable;
import nyla.solutions.core.patterns.loadbalancer.LoadBalanceRegistry;
import nyla.solutions.core.patterns.loadbalancer.RoundRobin;
import nyla.solutions.core.util.Config;

public class PropertiesLoadBalanceRegistry
implements LoadBalanceRegistry<String, String>,
SetUpable {
    private RoundRobin<String> roundRobin = new RoundRobin();
    private Properties properties;
    private String propertyFilePath = Config.getProperty(PropertiesLoadBalanceRegistry.class, "propertyFilePath");

    public PropertiesLoadBalanceRegistry() {
        this.setUp();
    }

    @Override
    public void setUp() {
        if (this.properties != null) {
            return;
        }
        try {
            if (this.propertyFilePath != null && this.propertyFilePath.length() > 0) {
                this.properties = IO.readProperties(this.propertyFilePath);
            }
        }
        catch (IOException e) {
            throw new SetupException("Cannot load properties :" + this.propertyFilePath, e);
        }
    }

    @Override
    public synchronized String lookup(String id) {
        String associated;
        if (this.properties == null) {
            this.setUp();
        }
        if ((associated = this.properties.getProperty(id)) == null) {
            associated = this.next();
            this.register(id, associated);
        }
        return associated;
    }

    @Override
    public void unregister(String associated) {
        if (associated == null || associated.length() == 0) {
            return;
        }
        try {
            if (this.properties != null) {
                Set<Object> keySet = this.properties.keySet();
                Iterator<Object> i = keySet.iterator();
                while (i.hasNext()) {
                    String prop = (String)i.next();
                    String location = this.properties.getProperty(prop);
                    if (!associated.equals(location)) continue;
                    i.remove();
                }
                IO.writeProperties(this.propertyFilePath, this.properties);
            }
            this.roundRobin.remove(associated);
        }
        catch (IOException e) {
            throw new SystemException("Unable to unregistry:" + associated + " ERROR:" + e.getMessage(), e);
        }
    }

    @Override
    public synchronized void register(String id, String location) {
        if (this.properties == null) {
            this.setUp();
        }
        try {
            this.properties.put(id, location);
            IO.writeProperties(this.propertyFilePath, this.properties);
        }
        catch (NullPointerException e) {
            throw new SetupException(e);
        }
        catch (IOException e) {
            throw new SetupException("Cannot write to property:\"" + this.propertyFilePath + "\" ERROR: " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized String next() {
        if (this.roundRobin == null) {
            return null;
        }
        return this.roundRobin.next();
    }

    @Override
    public Collection<String> listRegistered() {
        return this.roundRobin.toCollection();
    }

    @Override
    public synchronized void register(String location) {
        this.roundRobin.add(location);
    }

    public String getPropertyFilePath() {
        return this.propertyFilePath;
    }

    public void setPropertyFilePath(String propertyFilePath) {
        this.propertyFilePath = propertyFilePath;
    }
}

