/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.loadbalancer;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;

public class RoundRobin<T> {
    private final Deque<T> dq = new ArrayDeque<T>();

    public boolean add(T item) {
        if (item == null) {
            return false;
        }
        if (this.dq.contains(item)) {
            return false;
        }
        return this.dq.add(item);
    }

    public boolean addAll(Collection<T> items) {
        boolean wasAllAdded = true;
        for (T item : items) {
            if (this.add(item)) continue;
            wasAllAdded = false;
        }
        return wasAllAdded;
    }

    public T next() {
        if (this.dq == null || this.dq.isEmpty()) {
            return null;
        }
        T item = this.dq.removeFirst();
        this.dq.addLast(item);
        return item;
    }

    public Collection<T> toCollection() {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(Arrays.asList(this.dq.toArray()));
        return set;
    }

    public boolean remove(T item) {
        return this.dq.remove(item);
    }
}

